/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap;

import adams.core.Properties;
import adams.core.io.PlaceholderFile;
import adams.data.conversion.HeatmapToBufferedImage;
import adams.data.conversion.HeatmapToSpreadSheet;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.report.Report;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseLogPanel;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.BaseSplitPane;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.ColorHelper;
import adams.gui.core.SearchPanel;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.event.SearchEvent;
import adams.gui.event.SearchListener;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.heatmap.HeatmapViewerPanel;
import adams.gui.visualization.heatmap.overlay.AbstractHeatmapOverlay;
import adams.gui.visualization.image.ImageOverlay;
import adams.gui.visualization.image.ImagePanel;
import adams.gui.visualization.report.ReportFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class HeatmapPanel
extends BasePanel {
    private static final long serialVersionUID = 1897625268125110563L;
    protected static Properties m_Properties;
    protected Heatmap m_Heatmap;
    protected ImagePanel m_HeatmapImage;
    protected SpreadSheetTable m_HeatmapTable;
    protected ReportFactory.Table m_ReportTable;
    protected SearchPanel m_SearchPanel;
    protected BaseTabbedPane m_LogTabbedPane;
    protected BaseSplitPane m_SplitPane;
    protected BaseTabbedPane m_TabbedPane;
    protected HeatmapViewerPanel m_Owner;
    protected AbstractHeatmapReader m_Reader;
    protected AbstractColorGradientGenerator m_ColorGenerator;
    protected Color m_MissingValueColor;
    protected BaseLogPanel m_PanelLog;

    public HeatmapPanel(HeatmapViewerPanel owner) {
        this.m_Owner = owner;
    }

    protected void initialize() {
        super.initialize();
        Properties props = HeatmapPanel.getProperties();
        this.m_Owner = null;
        this.m_Heatmap = new Heatmap(0, 0);
        this.m_Reader = null;
        this.m_ColorGenerator = AbstractColorGradientGenerator.forCommandLine((String)props.getProperty("Image.GradientColorGenerator", new BiColorGenerator().toCommandLine()));
        this.m_MissingValueColor = props.getColor("Image.MissingValueColor", ColorHelper.valueOf((String)"#88ff0000"));
    }

    protected void initGUI() {
        super.initGUI();
        Properties props = HeatmapPanel.getProperties();
        this.setLayout(new BorderLayout());
        this.m_LogTabbedPane = new BaseTabbedPane();
        this.m_LogTabbedPane.setTabPlacement(3);
        this.add((Component)this.m_LogTabbedPane, "Center");
        this.m_SplitPane = new BaseSplitPane();
        this.m_SplitPane.setDividerLocation(props.getInteger("Panel.DividerLocation", Integer.valueOf(600)).intValue());
        this.m_LogTabbedPane.addTab("Data", (Component)this.m_SplitPane);
        this.m_HeatmapImage = new ImagePanel();
        this.m_HeatmapTable = null;
        if (props.getBoolean("SpreadSheet.Show", Boolean.valueOf(true)).booleanValue()) {
            this.m_TabbedPane = new BaseTabbedPane();
            this.m_SplitPane.setLeftComponent((Component)this.m_TabbedPane);
            this.m_TabbedPane.addTab("Image", (Component)this.m_HeatmapImage);
            this.m_HeatmapTable = new SpreadSheetTable(new SpreadSheet());
            this.m_HeatmapTable.setNumDecimals(props.getInteger("SpreadSheet.NumDecimals", Integer.valueOf(3)).intValue());
            this.m_TabbedPane.addTab("Raw", (Component)new BaseScrollPane((Component)this.m_HeatmapTable));
        } else {
            this.m_SplitPane.setLeftComponent((Component)this.m_HeatmapImage);
        }
        this.m_ReportTable = new ReportFactory.Table();
        this.m_SearchPanel = new SearchPanel(SearchPanel.LayoutType.HORIZONTAL, true, "_Search", true, null);
        this.m_SearchPanel.setMinimumChars(2);
        this.m_SearchPanel.addSearchListener(new SearchListener(){

            public void searchInitiated(SearchEvent e) {
                HeatmapPanel.this.search(HeatmapPanel.this.m_SearchPanel.getSearchText(), HeatmapPanel.this.m_SearchPanel.isRegularExpression());
            }
        });
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new BaseScrollPane((Component)this.m_ReportTable), "Center");
        panel.add((Component)this.m_SearchPanel, "South");
        this.m_SplitPane.setRightComponent((Component)panel);
        this.m_PanelLog = new BaseLogPanel();
        this.m_PanelLog.setRows(5);
        this.m_PanelLog.setColumns(80);
        this.m_LogTabbedPane.addTab("Log", (Component)this.m_PanelLog);
    }

    public HeatmapViewerPanel getOwner() {
        return this.m_Owner;
    }

    protected String refresh() {
        StringBuilder errors = new StringBuilder();
        Properties props = HeatmapPanel.getProperties();
        HeatmapToBufferedImage hm2bi = new HeatmapToBufferedImage();
        hm2bi.setInput(this.m_Heatmap);
        hm2bi.setGenerator(this.m_ColorGenerator);
        hm2bi.setMissingValueColor(this.m_MissingValueColor);
        String result = hm2bi.convert();
        if (result != null) {
            String error = "Failed to generate image: " + result;
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append(error);
            System.err.println(error);
            this.m_HeatmapImage.setCurrentImage((BufferedImage)null);
        } else {
            this.m_HeatmapImage.setCurrentImage(((AbstractImageContainer)hm2bi.getOutput()).toBufferedImage());
            this.m_HeatmapImage.setScale(props.getDouble("Image.Scale", Double.valueOf(-1.0)).doubleValue());
        }
        if (errors.length() == 0) {
            return null;
        }
        return errors.toString();
    }

    public void setHeatmap(Heatmap value) {
        this.m_Heatmap = value.getClone();
        Properties props = HeatmapPanel.getProperties();
        StringBuilder errors = new StringBuilder();
        String error = this.refresh();
        if (error != null) {
            errors.append(error);
        }
        if (this.m_HeatmapTable != null) {
            HeatmapToSpreadSheet hm2ss = new HeatmapToSpreadSheet();
            hm2ss.setInput(this.m_Heatmap);
            String result = hm2ss.convert();
            if (result != null) {
                error = "Failed to generate spreadsheet: " + result;
                if (errors.length() > 0) {
                    errors.append("\n");
                }
                errors.append(error);
                System.err.println(error);
                this.m_HeatmapTable.setModel((TableModel)new SpreadSheetTableModel());
            } else {
                this.m_HeatmapTable.setModel((TableModel)new SpreadSheetTableModel((SpreadSheet)hm2ss.getOutput()));
            }
            this.m_HeatmapTable.setNumDecimals(props.getInteger("SpreadSheet.NumDecimals", Integer.valueOf(3)).intValue());
        }
        this.m_ReportTable.setModel((TableModel)new ReportFactory.Model(this.m_Heatmap.getReport()));
        if (errors.length() > 0 && this.m_Owner != null) {
            this.m_Owner.showStatus(errors.toString());
        }
    }

    public Heatmap getHeatmap() {
        return this.m_Heatmap;
    }

    public void setReader(AbstractHeatmapReader value) {
        this.m_Reader = (AbstractHeatmapReader)value.shallowCopy(true);
    }

    public AbstractHeatmapReader getReader() {
        return this.m_Reader;
    }

    public void setColorGenerator(AbstractColorGradientGenerator value) {
        this.m_ColorGenerator = value;
        this.refresh();
    }

    public AbstractColorGradientGenerator getColorGenerator() {
        return this.m_ColorGenerator;
    }

    public void addOverlay(AbstractHeatmapOverlay overlay) {
        overlay = (AbstractHeatmapOverlay)overlay.shallowCopy();
        overlay.setHeatmapPanel(this);
        this.getImagePanel().addImageOverlay((ImageOverlay)overlay);
    }

    public void removeOverlays() {
        this.getImagePanel().clearImageOverlays();
    }

    public void setMissingValueColor(Color value) {
        this.m_MissingValueColor = value;
        this.refresh();
    }

    public Color getMissingValueColor() {
        return this.m_MissingValueColor;
    }

    public String getTitle() {
        return this.m_Heatmap.getID();
    }

    public ImagePanel getImagePanel() {
        return this.m_HeatmapImage;
    }

    public boolean canReload() {
        boolean result = false;
        Report report = this.m_Heatmap.getReport();
        if (!result && report.hasValue("Filename")) {
            PlaceholderFile file = new PlaceholderFile(report.getStringValue("Filename"));
            result = file.exists() && this.m_Reader != null;
        }
        return result;
    }

    public boolean reload() {
        Report report = this.m_Heatmap.getReport();
        if (this.getOwner() != null && report.hasValue("Filename") && this.m_Reader != null) {
            PlaceholderFile file = new PlaceholderFile(report.getStringValue("Filename"));
            AbstractHeatmapReader reader = (AbstractHeatmapReader)this.m_Reader.shallowCopy(true);
            double scale = this.getImagePanel().getScale();
            reader.setInput(file);
            List maps = reader.read();
            if (maps.size() >= 1) {
                this.setHeatmap((Heatmap)maps.get(0));
                this.getImagePanel().setScale(scale);
                reader.cleanUp();
                this.log("Reload: " + file);
                return true;
            }
            reader.cleanUp();
        }
        return false;
    }

    public void search(String text, boolean isRegExp) {
        this.m_ReportTable.search(text, isRegExp);
    }

    public void setSearchPanelVisible(boolean value) {
        this.m_SearchPanel.setVisible(value);
    }

    public boolean isSearchPanelVisible() {
        return this.m_SearchPanel.isVisible();
    }

    public static synchronized Properties getProperties() {
        if (m_Properties == null) {
            try {
                String props = HeatmapPanel.class.getName().replaceAll("\\.", "/") + ".props";
                m_Properties = Properties.read((String)props);
            }
            catch (Exception e) {
                m_Properties = new Properties();
            }
        }
        return m_Properties;
    }

    public void setZoom(double zoom) {
        this.m_HeatmapImage.setScale(zoom);
    }

    public double getZoom() {
        return this.m_HeatmapImage.getScale();
    }

    public void log(String msg) {
        this.m_PanelLog.append(msg);
    }
}

