/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.core.option.OptionUtils;
import adams.data.image.AbstractImageContainer;
import adams.data.imagej.ImagePlusContainer;
import adams.data.imagej.transformer.AbstractImageJTransformer;
import adams.data.imagej.transformer.PassThrough;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.plugins.AbstractApplyImageTransformer;
import ij.ImagePlus;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class ImageJTransformer
extends AbstractApplyImageTransformer {
    private static final long serialVersionUID = 8515360604357492725L;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "ImageJ transformer...";
    }

    public String getIconName() {
        return "imagej.gif";
    }

    @Override
    protected Class getEditorType() {
        return AbstractImageJTransformer.class;
    }

    @Override
    protected Object getDefaultValue() {
        return new PassThrough();
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + OptionUtils.getCommandLine((Object)this.m_Editor.getValue());
    }

    @Override
    protected BufferedImage process(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getValue());
        String title = ((HeatmapPanel)((Object)this.m_CurrentPanel)).getTitle();
        AbstractImageJTransformer transformer = (AbstractImageJTransformer)this.m_Editor.getValue();
        ImagePlusContainer input = new ImagePlusContainer();
        input.setImage((Object)new ImagePlus(title, (Image)image));
        ImagePlusContainer[] transformed = (ImagePlusContainer[])transformer.transform((AbstractImageContainer)input);
        if (transformed.length == 0) {
            this.getLogger().severe("No filtered image generated!");
        }
        if (transformed.length > 1) {
            this.getLogger().severe("WARNING: Generated more than one image, using only first one.");
        }
        if (transformed.length >= 1) {
            result = ((ImagePlus)transformed[0].getImage()).getBufferedImage();
        }
        return result;
    }
}

