/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.core.base.BaseText;
import adams.data.image.BufferedImageContainer;
import adams.flow.core.Token;
import adams.flow.transformer.ImageMagickTransformer;
import adams.gui.core.TextEditorPanel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.plugins.AbstractSelectedHeatmapsViewerPlugin;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ImageMagick
extends AbstractSelectedHeatmapsViewerPlugin {
    private static final long serialVersionUID = -8466066949642677596L;
    protected TextEditorPanel m_Editor;

    public String getMenu() {
        return "Process";
    }

    public String getCaption() {
        return "ImageMagick...";
    }

    public String getIconName() {
        return "imagemagick.png";
    }

    protected String createLogEntry() {
        return ((Object)((Object)this)).getClass().getSimpleName() + ": " + this.m_Editor.getContent();
    }

    protected BufferedImage process(BufferedImage image) {
        BufferedImage result = null;
        this.setLastSetup(this.m_Editor.getContent());
        ImageMagickTransformer transformer = new ImageMagickTransformer();
        transformer.setCommands(new BaseText(this.m_Editor.getContent()));
        String error = transformer.setUp();
        if (error == null) {
            BufferedImageContainer input = new BufferedImageContainer();
            input.setImage((Object)image);
            transformer.input(new Token((Object)input));
            error = transformer.execute();
            if (error == null && transformer.hasPendingOutput()) {
                result = (BufferedImage)((BufferedImageContainer)transformer.output().getPayload()).getImage();
            }
            transformer.wrapUp();
            transformer.cleanUp();
        }
        if (error != null) {
            this.getLogger().severe(error);
        }
        return result;
    }

    @Override
    protected JPanel createConfigurationPanel(ApprovalDialog dialog) {
        JPanel result = new JPanel(new BorderLayout());
        this.m_Editor = new TextEditorPanel();
        if (this.hasLastSetup()) {
            this.m_Editor.setContent((String)this.getLastSetup());
        } else {
            this.m_Editor.setContent("");
        }
        result.add((Component)new JLabel("Please enter the commands"), "North");
        result.add((Component)this.m_Editor, "Center");
        return result;
    }

    @Override
    protected String process(HeatmapPanel panel) {
        BufferedImage current = panel.getImagePanel().getCurrentImage();
        if ((current = this.process(current)) == null) {
            return "Failed to process image!";
        }
        panel.getImagePanel().setCurrentImage(current);
        return null;
    }
}

