/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;

public class BufferedImageToHeatmap
extends AbstractConversion {
    private static final long serialVersionUID = -3874290458679824062L;

    public String globalInfo() {
        return "Turns a " + BufferedImage.class + " into a heatmap.\nSimply uses the RGB value as heatmap value, but ignores the alpha value.";
    }

    public Class accepts() {
        return AbstractImageContainer.class;
    }

    public Class generates() {
        return Heatmap.class;
    }

    protected Object doConvert() throws Exception {
        BufferedImage image = ((AbstractImageContainer)this.m_Input).toBufferedImage();
        Heatmap result = new Heatmap(image.getHeight(), image.getWidth());
        WritableRaster raster = image.getRaster();
        ColorModel colorModel = image.getColorModel();
        for (int n = 0; n < image.getHeight(); ++n) {
            for (int i = 0; i < image.getWidth(); ++i) {
                Object data = raster.getDataElements(i, n, null);
                int value = colorModel.getRed(data) << 16 | colorModel.getGreen(data) << 8 | colorModel.getBlue(data) << 0;
                result.set(n, i, value);
            }
        }
        return result;
    }
}

