/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayMean;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.Serializable;

public class HeatmapArrayStatistic
extends AbstractTransformer {
    private static final long serialVersionUID = 8536100625511019961L;
    protected AbstractArrayStatistic m_Statistic;

    public String globalInfo() {
        return "Generates statistics from a heatmap, interpreting it as an array (row-wise concatenated).";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statistic", "statistic", (Object)new ArrayMean());
    }

    public void setStatistic(AbstractArrayStatistic value) {
        this.m_Statistic = value;
        this.reset();
    }

    public AbstractArrayStatistic getStatistic() {
        return this.m_Statistic;
    }

    public String statisticTipText() {
        return "The statistic to generate from the data.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"statistic", (Object)this.m_Statistic);
    }

    public Class[] accepts() {
        return new Class[]{Heatmap.class};
    }

    public Class[] generates() {
        return new Class[]{SpreadSheet.class};
    }

    protected String doExecute() {
        SpreadSheet sheet;
        String result = null;
        try {
            AbstractArrayStatistic stat = this.m_Statistic.shallowCopy(true);
            Heatmap map = (Heatmap)this.m_InputToken.getPayload();
            Serializable[] array = map.toDoubleArray();
            stat.add(array);
            sheet = stat.calculate().toSpreadSheet();
        }
        catch (Exception e) {
            result = this.handleException("Error generating the statistic: ", e);
            sheet = null;
        }
        if (sheet != null) {
            this.m_OutputToken = new Token(sheet);
        }
        return result;
    }
}

