/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.overlay;

import adams.data.heatmap.Heatmap;
import adams.gui.visualization.heatmap.overlay.AbstractSingleColorHeatmapOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;

public class LowestTemperature
extends AbstractSingleColorHeatmapOverlay {
    private static final long serialVersionUID = -2945211815191636810L;
    protected double m_Tolerance;
    protected List<Point> m_Points;

    public String globalInfo() {
        return "Overlays the heatmap with the points that have the lowest temperature.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("tolerance", "tolerance", (Object)0.0, (Number)0.0, null);
    }

    protected void reset() {
        super.reset();
        this.m_Points = null;
    }

    public void setTolerance(double value) {
        if (value >= 0.0) {
            this.m_Tolerance = value;
            this.reset();
        } else {
            this.getLogger().warning("Tolerance must be >= 0, provided: " + value);
        }
    }

    public double getTolerance() {
        return this.m_Tolerance;
    }

    public String toleranceTipText() {
        return "The tolerance to apply to values to still consider them 'lowest' temperature.";
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Points = null;
    }

    protected void locate(Heatmap map) {
        double lowest = map.getMin();
        this.m_Points = new ArrayList<Point>();
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                if (!(map.get(y, x) <= lowest - this.m_Tolerance)) continue;
                this.m_Points.add(new Point(x, y));
            }
        }
    }

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Points == null) {
            this.locate(this.m_HeatmapPanel.getHeatmap());
        }
        g.setColor(this.m_Color);
        for (Point p : this.m_Points) {
            int x = (int)p.getX();
            int y = (int)p.getY();
            g.drawLine(x, y, x, y);
        }
    }
}

