/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.core.Properties;
import adams.data.conversion.HeatmapToSpreadSheet;
import adams.data.spreadsheet.SpreadSheet;
import adams.gui.core.BaseMultiPagePane;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.SpreadSheetTable;
import adams.gui.core.SpreadSheetTableModel;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.plugins.AbstractSelectedHeatmapsViewerPlugin;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.table.TableModel;

public class SpreadSheetView
extends AbstractSelectedHeatmapsViewerPlugin {
    private static final long serialVersionUID = 3286345601880725626L;
    protected List<SpreadSheetTable> m_TableList;
    protected List<String> m_TitleList;
    protected Properties m_Properties;

    public String getMenu() {
        return "View";
    }

    public String getCaption() {
        return "Spreadsheet view";
    }

    public String getIconName() {
        return "spreadsheet.png";
    }

    @Override
    public boolean canExecute(HeatmapPanel panel) {
        return panel != null && panel.getHeatmap() != null;
    }

    @Override
    protected JPanel createConfigurationPanel(ApprovalDialog dialog) {
        return null;
    }

    @Override
    protected String processInit() {
        String result = super.processInit();
        if (result == null) {
            this.m_TableList = new ArrayList<SpreadSheetTable>();
            this.m_TitleList = new ArrayList<String>();
            this.m_Properties = null;
        }
        return result;
    }

    @Override
    protected String process(HeatmapPanel panel) {
        SpreadSheetTable table = new SpreadSheetTable(new SpreadSheetTableModel());
        HeatmapToSpreadSheet convert = new HeatmapToSpreadSheet();
        convert.setInput(panel.getHeatmap());
        String result = convert.convert();
        if (result != null) {
            return "Failed to generate spreadsheet: " + result;
        }
        if (this.m_Properties == null) {
            this.m_Properties = panel.getProperties();
        }
        table.setModel((TableModel)new SpreadSheetTableModel((SpreadSheet)convert.getOutput()));
        table.setNumDecimals(this.m_Properties.getInteger("SpreadSheet.NumDecimals", Integer.valueOf(3)).intValue());
        this.m_TableList.add(table);
        this.m_TitleList.add(panel.getTitle());
        return null;
    }

    @Override
    protected String processFinish() {
        String result = super.processFinish();
        if (result == null) {
            BaseMultiPagePane multipane = new BaseMultiPagePane();
            for (int i = 0; i < this.m_TableList.size(); ++i) {
                multipane.addPage(this.m_TitleList.get(i), (Component)new BaseScrollPane((Component)this.m_TableList.get(i)));
            }
            ApprovalDialog dialog = ((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentDialog() != null ? new ApprovalDialog(((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentDialog()) : new ApprovalDialog(((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentFrame());
            dialog.setTitle("Spreadsheet");
            dialog.setDefaultCloseOperation(2);
            dialog.setApproveVisible(true);
            dialog.setCancelVisible(false);
            dialog.setDiscardVisible(false);
            dialog.getContentPane().add((Component)multipane, "Center");
            dialog.setSize(this.m_Properties.getInteger("View.SpreadSheet.Width", Integer.valueOf(800)).intValue(), this.m_Properties.getInteger("View.SpreadSheet.Height", Integer.valueOf(600)).intValue());
            dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
            dialog.setVisible(true);
        }
        return result;
    }

    protected String createLogEntry() {
        return null;
    }
}

