/*
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * PassThrough.java
 * Copyright (C) 2011 University of Waikato, Hamilton, New Zealand
 */

package adams.data.featuregenerator;

import adams.data.heatmap.Heatmap;

/**
 <!-- globalinfo-start -->
 * A dummy generator that just passes the data through. No modifications to the report whatsoever.
 * <br><br>
 <!-- globalinfo-end -->
 *
 <!-- options-start -->
 * Valid options are: <br><br>
 *
 * <pre>-D (property: debug)
 *         If set to true, scheme may output additional info to the console.
 * </pre>
 *
 <!-- options-end -->
 *
 * @author  fracpete (fracpete at waikato dot ac dot nz)
 * @version $Revision: 10825 $
 */
public class PassThrough
  extends AbstractFeatureGenerator {

  /** for serialization. */
  private static final long serialVersionUID = 8646651693938769168L;

  /**
   * Returns a string describing the object.
   *
   * @return 			a description suitable for displaying in the gui
   */
  public String globalInfo() {
    return
        "A dummy generator that just passes the data through. No modifications to "
      + "the report whatsoever.";
  }

  /**
   * Does nothing with the report.
   *
   * @param data	the data to process
   * @return		the processed data
   */
  protected Heatmap processData(Heatmap data) {
    return data;
  }
}
