/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.flow.core.Token;
import adams.flow.sink.AbstractComponentDisplayPanel;
import adams.flow.sink.AbstractDisplayPanel;
import adams.flow.sink.AbstractGraphicalDisplay;
import adams.flow.sink.DisplayPanelProvider;
import adams.gui.core.BasePanel;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.overlay.AbstractHeatmapOverlay;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;

public class HeatmapDisplay
extends AbstractGraphicalDisplay
implements DisplayPanelProvider {
    private static final long serialVersionUID = -5963541661512220421L;
    protected AbstractColorGradientGenerator m_ColorGenerator;
    protected AbstractHeatmapOverlay[] m_Overlays;
    protected Color m_MissingValueColor;
    protected double m_Zoom;
    protected boolean m_ShowReportTable;

    public String globalInfo() {
        return "Actor that displays heatmaps.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("color-generator", "colorGenerator", (Object)new BiColorGenerator());
        this.m_OptionManager.add("overlay", "overlays", (Object)new AbstractHeatmapOverlay[0]);
        this.m_OptionManager.add("missing-value-color", "missingValueColor", (Object)new Color(255, 255, 255, 0));
        this.m_OptionManager.add("zoom", "zoom", (Object)100.0, (Number)-1.0, (Number)1600.0);
        this.m_OptionManager.add("show-report-table", "showReportTable", (Object)true);
    }

    protected int getDefaultWidth() {
        return 1000;
    }

    protected int getDefaultHeight() {
        return 700;
    }

    public void setColorGenerator(AbstractColorGradientGenerator value) {
        this.m_ColorGenerator = value;
        this.reset();
    }

    public AbstractColorGradientGenerator getColorGenerator() {
        return this.m_ColorGenerator;
    }

    public String colorGeneratorTipText() {
        return "The generator for the color gradient.";
    }

    public void setOverlays(AbstractHeatmapOverlay[] value) {
        this.m_Overlays = value;
        this.reset();
    }

    public AbstractHeatmapOverlay[] getOverlays() {
        return this.m_Overlays;
    }

    public String overlaysTipText() {
        return "The overlay(s) to use.";
    }

    public void setMissingValueColor(Color value) {
        this.m_MissingValueColor = value;
        this.reset();
    }

    public Color getMissingValueColor() {
        return this.m_MissingValueColor;
    }

    public String missingValueColorTipText() {
        return "The color to use for missing values.";
    }

    public void setZoom(double value) {
        if (value == -1.0 || value > 0.0 && value <= 1600.0) {
            this.m_Zoom = value;
            this.reset();
        } else {
            this.getLogger().warning("Zoom must -1 to fit window or 0 < x < 1600, provided: " + value);
        }
    }

    public double getZoom() {
        return this.m_Zoom;
    }

    public String zoomTipText() {
        return "The zoom level in percent.";
    }

    public void setShowReportTable(boolean value) {
        this.m_ShowReportTable = value;
        this.reset();
    }

    public boolean getShowReportTable() {
        return this.m_ShowReportTable;
    }

    public String showReportTableTipText() {
        return "Determines the visibility of the report table.";
    }

    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"colorGenerator", (Object)this.m_ColorGenerator, (String)", generator: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"missingValueColor", (Object)this.m_MissingValueColor, (String)", missing: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"zoom", (Object)this.m_Zoom, (String)", zoom: ");
        return result;
    }

    public void clearPanel() {
        if (this.m_Panel != null) {
            ((HeatmapPanel)this.m_Panel).setHeatmap(null);
        }
    }

    protected BasePanel newPanel() {
        HeatmapPanel result = new HeatmapPanel(null);
        result.setColorGenerator(this.m_ColorGenerator);
        for (AbstractHeatmapOverlay overlay : this.m_Overlays) {
            result.addOverlay(overlay);
        }
        result.setMissingValueColor(this.m_MissingValueColor);
        result.setZoom(this.m_Zoom / 100.0);
        result.setReportVisible(this.m_ShowReportTable);
        result.setLogVisible(false);
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Heatmap.class};
    }

    protected void display(Token token) {
        ((HeatmapPanel)this.m_Panel).setHeatmap((Heatmap)token.getPayload());
    }

    public AbstractDisplayPanel createDisplayPanel(Token token) {
        AbstractComponentDisplayPanel result = new AbstractComponentDisplayPanel(((Object)((Object)this)).getClass().getSimpleName()){
            private static final long serialVersionUID = -9139363702312636367L;
            protected HeatmapPanel m_HeatmapPanel;

            protected void initGUI() {
                super.initGUI();
                this.setLayout(new BorderLayout());
                this.m_HeatmapPanel = new HeatmapPanel(null);
                this.m_HeatmapPanel.setColorGenerator(HeatmapDisplay.this.m_ColorGenerator);
                for (AbstractHeatmapOverlay overlay : HeatmapDisplay.this.m_Overlays) {
                    this.m_HeatmapPanel.addOverlay(overlay);
                }
                this.m_HeatmapPanel.setMissingValueColor(HeatmapDisplay.this.m_MissingValueColor);
                this.m_HeatmapPanel.setZoom(HeatmapDisplay.this.m_Zoom / 100.0);
                this.m_HeatmapPanel.setReportVisible(HeatmapDisplay.this.m_ShowReportTable);
                this.m_HeatmapPanel.setLogVisible(false);
                this.add((Component)((Object)this.m_HeatmapPanel), "Center");
            }

            public void display(Token token) {
                this.m_HeatmapPanel.setHeatmap((Heatmap)token.getPayload());
            }

            public void cleanUp() {
            }

            public void clearPanel() {
            }

            public JComponent supplyComponent() {
                return this.m_HeatmapPanel;
            }
        };
        if (token != null) {
            result.display(token);
        }
        return result;
    }

    public boolean displayPanelRequiresScrollPane() {
        return false;
    }
}

