/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.overlay;

import adams.gui.visualization.heatmap.overlay.AbstractHeatmapOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class AbstractPositionableHeatmapOverlay
extends AbstractHeatmapOverlay {
    private static final long serialVersionUID = 5439828929470172755L;
    protected int m_X;
    protected int m_Y;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "x", (Object)this.getDefaultX(), (Number)-3, null);
        this.m_OptionManager.add("y", "y", (Object)this.getDefaultY(), (Number)-3, null);
    }

    protected int getDefaultX() {
        return -3;
    }

    public void setX(int value) {
        this.m_X = value;
        this.reset();
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The X position of the overlay (>=0: absolute, -1: left, -2: center, -3: right).";
    }

    protected int getDefaultY() {
        return -1;
    }

    public void setY(int value) {
        this.m_Y = value;
        this.reset();
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The Y position of the overlay (>=0: absolute, -1: top, -2: center, -3: bottom).";
    }

    protected int getHeight() {
        return 0;
    }

    protected int getWidth() {
        return 0;
    }

    protected abstract void doPaintOverlay(ImagePanel.PaintPanel var1, Graphics var2, int var3, int var4);

    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        int actX = this.m_X;
        int actY = this.m_Y;
        Rectangle bounds = panel.getBounds();
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("bounds: " + bounds);
        }
        actX = this.m_X == -1 ? 0 : (this.m_X == -2 ? (bounds.width - this.getWidth()) / 2 : (this.m_X == -3 ? bounds.width - this.getWidth() : this.m_X));
        actY = this.m_Y == -1 ? 0 : (this.m_Y == -2 ? (bounds.height - this.getHeight()) / 2 : (this.m_Y == -3 ? bounds.height - this.getHeight() : this.m_Y));
        actY += this.getHeight();
        if (this.isLoggingEnabled()) {
            this.getLogger().fine("x: " + this.m_X + " -> " + actX + ", y: " + this.m_Y + " -> " + actY);
        }
        this.doPaintOverlay(panel, g, actX, actY);
    }
}

