/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.plugins;

import adams.core.option.OptionUtils;
import adams.data.heatmap.Heatmap;
import adams.data.statistics.ArrayHistogram;
import adams.gui.core.BaseMultiPagePane;
import adams.gui.dialog.ApprovalDialog;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.HistogramPanel;
import adams.gui.visualization.heatmap.plugins.AbstractSelectedHeatmapsViewerPluginWithGOE;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;

public class Histogram
extends AbstractSelectedHeatmapsViewerPluginWithGOE {
    private static final long serialVersionUID = 3286345601880725626L;
    protected List<HistogramPanel> m_HistogramList;
    protected List<String> m_TitleList;

    public String getMenu() {
        return "View";
    }

    public String getCaption() {
        return "Histogram...";
    }

    public String getIconName() {
        return "histogram.png";
    }

    @Override
    public boolean canExecute(HeatmapPanel panel) {
        return panel != null && panel.getHeatmap() != null;
    }

    @Override
    protected boolean getCanChangeClassInDialog() {
        return false;
    }

    @Override
    protected Class getEditorType() {
        return ArrayHistogram.class;
    }

    @Override
    protected Object getDefaultValue() {
        return new ArrayHistogram();
    }

    @Override
    protected String processInit() {
        String result = super.processInit();
        if (result == null) {
            this.m_HistogramList = new ArrayList<HistogramPanel>();
            this.m_TitleList = new ArrayList<String>();
        }
        return result;
    }

    @Override
    protected String process(HeatmapPanel panel) {
        Heatmap map = panel.getHeatmap();
        HistogramPanel histo = new HistogramPanel();
        histo.setArrayHistogram((ArrayHistogram)this.getLastSetup());
        histo.setData(map);
        this.m_HistogramList.add(histo);
        this.m_TitleList.add(panel.getTitle());
        return null;
    }

    @Override
    protected String processFinish() {
        String result = super.processFinish();
        if (result == null) {
            BaseMultiPagePane multipane = new BaseMultiPagePane();
            for (int i = 0; i < this.m_HistogramList.size(); ++i) {
                multipane.addPage(this.m_TitleList.get(i), (Component)((Object)this.m_HistogramList.get(i)));
            }
            ApprovalDialog dialog = ((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentDialog() != null ? new ApprovalDialog(((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentDialog()) : new ApprovalDialog(((HeatmapPanel)((Object)this.m_CurrentPanel)).getParentFrame());
            dialog.setTitle("Histogram");
            dialog.setDefaultCloseOperation(2);
            dialog.setApproveVisible(true);
            dialog.setCancelVisible(false);
            dialog.setDiscardVisible(false);
            dialog.getContentPane().add((Component)multipane, "Center");
            dialog.pack();
            dialog.setLocationRelativeTo((Component)this.m_CurrentPanel);
            dialog.setVisible(true);
        }
        return result;
    }

    protected String createLogEntry() {
        return "Histogram: " + OptionUtils.getCommandLine((Object)this.getLastSetup());
    }
}

