/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractHeatmapFilterTestCase;
import adams.data.filter.Filter;
import adams.data.filter.HeatmapNormalizeToField;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.env.Environment;
import junit.framework.Test;
import junit.framework.TestSuite;

public class HeatmapNormalizeToFieldTest
extends AbstractHeatmapFilterTestCase {
    public static final String FIELD = "Blah";

    public HeatmapNormalizeToFieldTest(String name) {
        super(name);
    }

    @Override
    protected Heatmap load(String filename) {
        Heatmap result = super.load(filename);
        if (result != null) {
            result.getReport().addField((AbstractField)new Field(FIELD, DataType.NUMERIC));
            result.getReport().setNumericValue(FIELD, 10.0);
        }
        return result;
    }

    protected String[] getRegressionInputFiles() {
        return new String[]{"simple.csv"};
    }

    protected Filter[] getRegressionSetups() {
        HeatmapNormalizeToField[] result = new HeatmapNormalizeToField[]{new HeatmapNormalizeToField()};
        result[0].setField(new Field(FIELD, DataType.NUMERIC));
        return result;
    }

    public static Test suite() {
        return new TestSuite(HeatmapNormalizeToFieldTest.class);
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        HeatmapNormalizeToFieldTest.runTest((Test)HeatmapNormalizeToFieldTest.suite());
    }
}

