/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.overlay;

import adams.core.Utils;
import adams.data.filter.HeatmapCentroid;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.gui.visualization.heatmap.overlay.AbstractSingleColorHeatmapOverlay;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Graphics;

public class Centroid
extends AbstractSingleColorHeatmapOverlay {
    private static final long serialVersionUID = -2945211815191636810L;
    protected double[] m_Centroid;

    public String globalInfo() {
        return "Paints the centroid's location over the heatmap image.";
    }

    protected void reset() {
        super.reset();
        this.m_Centroid = null;
    }

    protected void calcCentroid() {
        HeatmapCentroid centroid = new HeatmapCentroid();
        Heatmap map = (Heatmap)centroid.filter(this.m_HeatmapPanel.getHeatmap());
        this.m_Centroid = new double[2];
        this.m_Centroid[0] = map.getReport().getDoubleValue((AbstractField)new Field("Centroid.X", DataType.NUMERIC));
        this.m_Centroid[1] = map.getReport().getDoubleValue((AbstractField)new Field("Centroid.Y", DataType.NUMERIC));
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
        this.m_Centroid = null;
    }

    protected synchronized void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g) {
        if (this.m_Centroid == null) {
            this.calcCentroid();
        }
        if (this.m_Centroid[0] == -1.0 || this.m_Centroid[1] == -1.0) {
            this.getLogger().severe("Cannot paint centroid: " + Utils.arrayToString((Object)this.m_Centroid));
            return;
        }
        int x = (int)Math.round(this.m_Centroid[0]);
        int y = (int)Math.round(this.m_Centroid[1]);
        g.setColor(this.m_Color);
        g.drawLine(x, 0, x, panel.getOwner().getHeight() - 1);
        g.drawLine(0, y, panel.getOwner().getWidth() - 1, y);
    }
}

