/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.overlay;

import adams.data.report.AbstractField;
import adams.data.report.Field;
import adams.data.report.Report;
import adams.gui.core.Fonts;
import adams.gui.visualization.heatmap.overlay.AbstractPositionableHeatmapOverlayWithDimensions;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;

public class TextOverlay
extends AbstractPositionableHeatmapOverlayWithDimensions {
    private static final long serialVersionUID = 805661569976845842L;
    protected int m_OffsetX;
    protected int m_OffsetY;
    protected String m_Text;
    protected Field m_ReportField;
    protected Color m_TextColor;
    protected Font m_Font;

    public String globalInfo() {
        return "Displays text as overlay, either the fixed text, or if empty, a report value.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("offset-x", "offsetX", (Object)4);
        this.m_OptionManager.add("offset-y", "offsetY", (Object)-4);
        this.m_OptionManager.add("text", "text", (Object)"");
        this.m_OptionManager.add("report-field", "reportField", (Object)new Field());
        this.m_OptionManager.add("text-color", "textColor", (Object)Color.RED);
        this.m_OptionManager.add("font", "font", (Object)Fonts.getSansFont());
    }

    @Override
    protected int getDefaultHeight() {
        return 20;
    }

    @Override
    public String heightTipText() {
        return "The height of the bounding box around the text.";
    }

    @Override
    protected int getDefaultWidth() {
        return 100;
    }

    @Override
    public String widthTipText() {
        return "The width of the bounding box around the text.";
    }

    public void setOffsetX(int value) {
        this.m_OffsetX = value;
        this.reset();
    }

    public int getOffsetX() {
        return this.m_OffsetX;
    }

    public String offsetXTipText() {
        return "The X offset for the text.";
    }

    public void setOffsetY(int value) {
        this.m_OffsetY = value;
        this.reset();
    }

    public int getOffsetY() {
        return this.m_OffsetY;
    }

    public String offsetYTipText() {
        return "The Y offset for the text.";
    }

    public void setText(String value) {
        this.m_Text = value;
        this.reset();
    }

    public String getText() {
        return this.m_Text;
    }

    public String textTipText() {
        return "The fixed text to output.";
    }

    public void setReportField(Field value) {
        this.m_ReportField = value;
        this.reset();
    }

    public Field getReportField() {
        return this.m_ReportField;
    }

    public String reportFieldTipText() {
        return "The report field to display.";
    }

    public void setTextColor(Color value) {
        this.m_TextColor = value;
        this.reset();
    }

    public Color getTextColor() {
        return this.m_TextColor;
    }

    public String textColorTipText() {
        return "The text color.";
    }

    public void setFont(Font value) {
        this.m_Font = value;
        this.reset();
    }

    public Font getFont() {
        return this.m_Font;
    }

    public String fontTipText() {
        return "The font to use for the text.";
    }

    protected synchronized void doImageChanged(ImagePanel.PaintPanel panel) {
    }

    @Override
    protected void doPaintOverlay(ImagePanel.PaintPanel panel, Graphics g, int x, int y) {
        Report report;
        String str = "";
        if (this.m_Text.length() > 0) {
            str = this.m_Text;
        } else if (this.m_HeatmapPanel.getHeatmap().hasReport() && (report = this.m_HeatmapPanel.getHeatmap().getReport()).hasValue((AbstractField)this.m_ReportField)) {
            str = "" + report.getValue((AbstractField)this.m_ReportField);
        }
        g.setColor(this.m_TextColor);
        g.setFont(this.m_Font);
        g.drawString(str, x + this.m_OffsetX, y + this.m_OffsetY);
    }
}

