/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featuregenerator;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.featuregenerator.AbstractFeatureGenerator;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.data.report.Report;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.Regression;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractFeatureGeneratorTestCase
extends AbstractDatabaseTestCase {
    public AbstractFeatureGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/featuregenerator/data");
    }

    protected List<Heatmap> load(String filename, AbstractHeatmapReader reader) {
        this.m_TestHelper.copyResourceToTmp(filename);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        List result = reader.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected List<Report> process(AbstractFeatureGenerator generator, List<Heatmap> data) {
        ArrayList<Report> result = new ArrayList<Report>();
        for (Heatmap d : data) {
            Report backup = d.getReport().getClone();
            d = generator.generate(d);
            result.add(d.getReport().minus(backup));
        }
        return result;
    }

    protected boolean save(List<Report> data, String filename, int[] ignored) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            output.append("#" + (i + 1) + ":\n");
            List lines = Arrays.asList(data.get(i).toString().split("\n"));
            lines = Regression.trim(lines, (int[])ignored);
            for (int n = 0; n < lines.size(); ++n) {
                output.append((String)lines.get(n) + "\n");
            }
            output.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)output, (boolean)false);
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractHeatmapReader[] getRegressionInputFileReaders();

    protected abstract AbstractFeatureGenerator[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected String createOutputFilename(String input, int no) {
        String result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = result + ext;
            result = result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        AbstractHeatmapReader[] readers = this.getRegressionInputFileReaders();
        String[] output = new String[input.length];
        AbstractFeatureGenerator[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractFeatureGeneratorTestCase.assertEquals((String)"Number of files and readers differ!", (int)input.length, (int)readers.length);
        AbstractFeatureGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractFeatureGeneratorTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            AbstractFeatureGenerator current = (AbstractFeatureGenerator)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractFeatureGeneratorTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            List<Heatmap> data = this.load(input[i], readers[i]);
            AbstractFeatureGeneratorTestCase.assertNotNull((String)"Failed to read data?", data);
            List<Report> processed = this.process(current, data);
            AbstractFeatureGeneratorTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i], ignored);
            AbstractFeatureGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            if (!(current instanceof Destroyable)) continue;
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractFeatureGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                ((CleanUpHandler)setups[i]).cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

