/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter.heatmapcrop;

import adams.data.filter.heatmapcrop.AbstractHeatmapCrop;
import adams.data.heatmap.Heatmap;

public class Rectangle
extends AbstractHeatmapCrop {
    private static final long serialVersionUID = 8109859053628417241L;
    protected int m_X;
    protected int m_Y;
    protected int m_Height;
    protected int m_Width;

    public String globalInfo() {
        return "Crops the map to the specified rectangle x and y (both 1-based), width and height.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("x", "x", (Object)1, (Number)1, null);
        this.m_OptionManager.add("y", "y", (Object)1, (Number)1, null);
        this.m_OptionManager.add("height", "height", (Object)240, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)320, (Number)1, null);
    }

    public void setX(int value) {
        if (this.getOptionManager().isValid("x", (Number)value)) {
            this.m_X = value;
            this.reset();
        }
    }

    public int getX() {
        return this.m_X;
    }

    public String xTipText() {
        return "The row of the top-left corner, the starting point of the rectangle (1-based).";
    }

    public void setY(int value) {
        if (this.getOptionManager().isValid("y", (Number)value)) {
            this.m_Y = value;
            this.reset();
        }
    }

    public int getY() {
        return this.m_Y;
    }

    public String yTipText() {
        return "The column of the top-left corner, the starting point of the rectangle (1-based).";
    }

    public void setHeight(int value) {
        if (this.getOptionManager().isValid("height", (Number)value)) {
            this.m_Height = value;
            this.reset();
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the rectangle.";
    }

    public void setWidth(int value) {
        if (this.getOptionManager().isValid("width", (Number)value)) {
            this.m_Width = value;
            this.reset();
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the rectangle.";
    }

    @Override
    protected Heatmap doCrop(Heatmap map) {
        return map.submap(this.m_Y - 1, this.m_X - 1, this.m_Height, this.m_Width);
    }
}

