/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmapfeatures;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.heatmap.Heatmap;
import adams.data.heatmapfeatures.AbstractHeatmapFeatureGeneratorWithSkippableMissingValues;
import adams.data.report.DataType;
import adams.data.statistics.AbstractArrayStatistic;
import adams.data.statistics.ArrayHistogram;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Histogram
extends AbstractHeatmapFeatureGeneratorWithSkippableMissingValues {
    private static final long serialVersionUID = -8349656592325229512L;
    protected int m_NumBins;
    protected boolean m_UseFixedMinMax;
    protected double m_ManualMin;
    protected double m_ManualMax;

    public String globalInfo() {
        return "Generates a histogram.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("num-bins", "numBins", (Object)50, (Number)1, null);
        this.m_OptionManager.add("use-fixed-min-max", "useFixedMinMax", (Object)false);
        this.m_OptionManager.add("manual-min", "manualMin", (Object)0.0);
        this.m_OptionManager.add("manual-max", "manualMax", (Object)1.0);
    }

    public void setNumBins(int value) {
        this.m_NumBins = value;
        this.reset();
    }

    public int getNumBins() {
        return this.m_NumBins;
    }

    public String numBinsTipText() {
        return "The number of bins to use in case of manual bin calculation.";
    }

    public void setUseFixedMinMax(boolean value) {
        this.m_UseFixedMinMax = value;
        this.reset();
    }

    public boolean getUseFixedMinMax() {
        return this.m_UseFixedMinMax;
    }

    public String useFixedMinMaxTipText() {
        return "If enabled, then the user-specified min/max values are used for the bin calculation rather than the min/max from the data (allows comparison of histograms when generating histograms over a range of arrays).";
    }

    public void setManualMin(double value) {
        this.m_ManualMin = value;
        this.reset();
    }

    public double getManualMin() {
        return this.m_ManualMin;
    }

    public String manualMinTipText() {
        return "The minimum to use when using manual binning with user-supplied min/max enabled.";
    }

    public void setManualMax(double value) {
        this.m_ManualMax = value;
        this.reset();
    }

    public double getManualMax() {
        return this.m_ManualMax;
    }

    public String manualMaxTipText() {
        return "The maximum to use when using manual binning with user-supplied max/max enabled.";
    }

    @Override
    public HeaderDefinition createHeader(Heatmap map) {
        HeaderDefinition result = new HeaderDefinition();
        for (int i = 0; i < this.m_NumBins; ++i) {
            result.add("bin_" + (i + 1), DataType.NUMERIC);
        }
        return result;
    }

    @Override
    public List<Object>[] generateRows(Heatmap map) {
        List[] result = new List[]{new ArrayList()};
        Serializable[] values = map.toDoubleArray(this.m_SkipMissing);
        ArrayHistogram histo = new ArrayHistogram();
        histo.setBinCalculation(ArrayHistogram.BinCalculation.MANUAL);
        histo.setNumBins(this.m_NumBins);
        histo.setUseFixedMinMax(this.m_UseFixedMinMax);
        histo.setManualMin(this.m_ManualMin);
        histo.setManualMax(this.m_ManualMax);
        histo.add(values);
        AbstractArrayStatistic.StatisticContainer cont = histo.calculate();
        for (int i = 0; i < cont.getColumnCount(); ++i) {
            result[0].add(((Number)cont.getCell(0, i)).doubleValue());
        }
        return result;
    }
}

