/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmapfeatures;

import adams.data.featureconverter.HeaderDefinition;
import adams.data.heatmap.Heatmap;
import adams.data.heatmapfeatures.AbstractHeatmapFeatureGeneratorWithSkippableMissingValues;
import adams.data.report.DataType;
import adams.data.statistics.StatUtils;
import java.util.ArrayList;
import java.util.List;

public class StandardDeviation
extends AbstractHeatmapFeatureGeneratorWithSkippableMissingValues {
    private static final long serialVersionUID = -8349656592325229512L;
    protected boolean m_IsSample;

    public String globalInfo() {
        return "Determines the standard deviation.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("is-sample", "isSample", (Object)false);
    }

    public void setIsSample(boolean value) {
        this.m_IsSample = value;
        this.reset();
    }

    public boolean getIsSample() {
        return this.m_IsSample;
    }

    public String isSampleTipText() {
        return "If set to true, the arrays are treated as samples and not as populations.";
    }

    @Override
    public HeaderDefinition createHeader(Heatmap map) {
        HeaderDefinition result = new HeaderDefinition();
        result.add("stdev" + (this.getIsSample() ? "" : "p"), DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(Heatmap map) {
        List[] result = new List[]{new ArrayList()};
        Number[] values = map.toDoubleArray(this.m_SkipMissing);
        result[0].add(StatUtils.stddev((Number[])values, (boolean)this.getIsSample()));
        return result;
    }
}

