/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.ClassLister;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractDataContainerReader;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

public abstract class AbstractHeatmapReader
extends AbstractDataContainerReader<Heatmap> {
    private static final long serialVersionUID = -2206748744422806213L;
    protected boolean m_UseAbsoluteSource;

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("use-absolute-source", "useAbsoluteSource", (Object)this.getUseAbsoluteSource());
    }

    protected boolean getDefaultUseAbsoluteSource() {
        return true;
    }

    public void setUseAbsoluteSource(boolean value) {
        this.m_UseAbsoluteSource = value;
        this.reset();
    }

    public boolean getUseAbsoluteSource() {
        return this.m_UseAbsoluteSource;
    }

    public String useAbsoluteSourceTipText() {
        return "If enabled the source report field stores the absolute file name rather than just the name.";
    }

    protected void postProcessData() {
        super.postProcessData();
        for (Heatmap map : this.m_ReadData) {
            if (map.hasReport()) {
                map.getReport().addField((AbstractField)new Field("Filename", DataType.STRING));
                if (this.m_UseAbsoluteSource) {
                    map.getReport().setStringValue("Filename", this.m_Input.getAbsolutePath());
                } else {
                    map.getReport().setStringValue("Filename", this.m_Input.getName());
                }
            }
            if (map.getID().trim().length() != 0) continue;
            map.setID(this.m_Input.getName());
        }
    }

    public static String[] getReaders() {
        return ClassLister.getSingleton().getClassnames(AbstractHeatmapReader.class);
    }
}

