/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.selection;

import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.gui.event.HeatmapPanelSelectionEvent;
import adams.gui.event.HeatmapPanelSelectionListener;
import adams.gui.visualization.heatmap.HeatmapPanel;
import java.awt.Point;

public abstract class AbstractSelectionProcessor
extends AbstractOptionHandler
implements HeatmapPanelSelectionListener,
ShallowCopySupporter<AbstractSelectionProcessor> {
    private static final long serialVersionUID = 3515366296579391750L;

    protected void doHeatmapChanged(HeatmapPanel panel) {
        this.reset();
    }

    @Override
    public void heatmapChanged(HeatmapPanel panel) {
        this.doHeatmapChanged(panel);
    }

    protected abstract void doProcessSelection(HeatmapPanel var1, Point var2, Point var3, int var4);

    public void processSelection(HeatmapPanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        this.doProcessSelection(panel, topLeft, bottomRight, modifiersEx);
        panel.repaint();
    }

    protected String check(HeatmapPanelSelectionEvent e) {
        if (e.getHeatmapPanel() == null) {
            return "No HeatmapPanel associated with event!";
        }
        if (e.getTopLeft() == null) {
            return "No top-left position associated with event!";
        }
        if (e.getBottomRight() == null) {
            return "No bottom-right position associated with event!";
        }
        return null;
    }

    @Override
    public void selected(HeatmapPanelSelectionEvent e) {
        String msg = this.check(e);
        if (msg == null) {
            this.processSelection(e.getHeatmapPanel(), e.getTopLeft(), e.getBottomRight(), e.getModifiersEx());
        } else {
            this.getLogger().severe(msg);
        }
    }

    public AbstractSelectionProcessor shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractSelectionProcessor shallowCopy(boolean expand) {
        return (AbstractSelectionProcessor)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }
}

