/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseString;
import adams.core.option.OptionHandler;
import adams.data.conversion.AbstractConversion;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.gui.visualization.core.AbstractColorGradientGenerator;
import adams.gui.visualization.core.BiColorGenerator;
import adams.parser.GrammarSupplier;
import adams.parser.MathematicalExpression;
import adams.parser.MathematicalExpressionText;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class HeatmapToBufferedImageExpression
extends AbstractConversion
implements GrammarSupplier {
    private static final long serialVersionUID = 2535421741524997185L;
    protected AbstractColorGradientGenerator m_Generator;
    protected Color m_MissingValueColor;
    protected MathematicalExpressionText m_Expression;
    protected Color[] m_GradientColors;

    public String globalInfo() {
        return "Turns a heatmap into a BufferedImage, using the provided expression for generating greyscale values (0-255).\n\nThe following grammar is used:\n\n" + this.getGrammar();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new BiColorGenerator());
        this.m_OptionManager.add("missing-value-color", "missingValueColor", (Object)new Color(255, 255, 255, 0));
        this.m_OptionManager.add("expression", "expression", (Object)new MathematicalExpressionText("(X - 273.15) / 50"));
    }

    protected void reset() {
        super.reset();
        this.m_GradientColors = null;
    }

    public String getGrammar() {
        return new MathematicalExpression().getGrammar();
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"expression", (Object)this.m_Expression.getValue());
    }

    public void setGenerator(AbstractColorGradientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public AbstractColorGradientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for creating the gradient colors.";
    }

    public void setMissingValueColor(Color value) {
        this.m_MissingValueColor = value;
        this.reset();
    }

    public Color getMissingValueColor() {
        return this.m_MissingValueColor;
    }

    public String missingValueColorTipText() {
        return "The color to use for missing values.";
    }

    public void setExpression(MathematicalExpressionText value) {
        this.m_Expression = value;
        this.reset();
    }

    public MathematicalExpressionText getExpression() {
        return this.m_Expression;
    }

    public String expressionTipText() {
        return "The expression to use for generating the greyscale values.";
    }

    public Class accepts() {
        return Heatmap.class;
    }

    public Class generates() {
        return AbstractImageContainer.class;
    }

    protected Color[] getGradientColors() {
        if (this.m_GradientColors == null) {
            this.m_GradientColors = this.m_Generator.generate();
        }
        return this.m_GradientColors;
    }

    protected Object doConvert() throws Exception {
        Heatmap map = (Heatmap)this.m_Input;
        Color[] colors = this.getGradientColors();
        BufferedImage image = new BufferedImage(map.getWidth(), map.getHeight(), 1);
        Graphics2D g = image.createGraphics();
        MathematicalExpression expr = new MathematicalExpression();
        expr.setExpression(this.m_Expression.getValue());
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                Color color;
                if (map.isMissing(y, x)) {
                    color = this.m_MissingValueColor;
                } else {
                    expr.setSymbols(new BaseString[]{new BaseString("X=" + map.get(y, x))});
                    double val = (Double)expr.evaluate();
                    color = colors[(int)(val * (double)(colors.length - 2)) + 1];
                }
                g.setColor(color);
                g.drawLine(x, y, x, y);
            }
        }
        BufferedImageContainer result = new BufferedImageContainer();
        result.setImage((Object)image);
        return result;
    }
}

