/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;

public class HeatmapNormalizeToField
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -1306518673446335794L;
    protected Field m_Field;

    public String globalInfo() {
        return "Divides all the heatmap values by the value of the specified numeric field.\nIf the report field is not available or not numeric, then an error gets attached to the notes.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("field", "field", (Object)new Field("Temperature", DataType.NUMERIC));
    }

    public void setField(Field value) {
        this.m_Field = value;
        this.reset();
    }

    public Field getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The (numeric) field in the report to normalize all the heatmap values against (ie, simply divide them by this value).";
    }

    protected Heatmap processData(Heatmap data) {
        if (!data.hasReport()) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "No report attached!");
            return result;
        }
        if (!data.getReport().hasValue((AbstractField)this.m_Field)) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "Field '" + this.m_Field + "' not found in report!");
            return result;
        }
        if (!(data.getReport().getValue((AbstractField)this.m_Field) instanceof Double)) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "Field '" + this.m_Field + "' not numeric!");
            return result;
        }
        double factor = data.getReport().getDoubleValue((AbstractField)this.m_Field);
        if (factor == 0.0) {
            Heatmap result = data.getClone();
            result.getNotes().addError(((Object)((Object)this)).getClass(), "Field '" + this.m_Field + "' is zero!");
            return result;
        }
        Heatmap result = data.getHeader();
        Double[] values = data.toDoubleArray();
        int i = 0;
        while (i < values.length) {
            Double[] doubleArray = values;
            int n = i++;
            Double.valueOf(doubleArray[n] / factor);
        }
        result.set(values);
        return result;
    }
}

