/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmapfeatures;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.featureconverter.HeaderDefinition;
import adams.data.heatmap.Heatmap;
import adams.data.heatmapfeatures.AbstractHeatmapFeatureGenerator;
import adams.data.heatmapfeatures.AbstractMetaHeatmapFeatureGenerator;
import adams.data.heatmapfeatures.Values;
import adams.data.report.DataType;
import java.util.ArrayList;
import java.util.List;

public class CountValues
extends AbstractMetaHeatmapFeatureGenerator {
    private static final long serialVersionUID = -5349388859224578387L;
    public static final String NAN = "NaN";
    protected double m_Minimum;
    protected boolean m_MinimumIncluded;
    protected double m_Maximum;
    protected boolean m_MaximumIncluded;
    protected String m_Label;

    public String globalInfo() {
        return "Meta-feature-generator that counts numeric values that satisfy the specified min/max range.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("minimum", "minimum", (Object)Double.NaN);
        this.m_OptionManager.add("minimum-included", "minimumIncluded", (Object)false);
        this.m_OptionManager.add("maximum", "maximum", (Object)Double.NaN);
        this.m_OptionManager.add("maximum-included", "maximumIncluded", (Object)false);
        this.m_OptionManager.add("label", "label", (Object)"");
    }

    @Override
    protected AbstractHeatmapFeatureGenerator getDefaultGenerator() {
        return new Values();
    }

    @Override
    public String generatorTipText() {
        return "The base feature generator to use for generating data to be used as input for the counts.";
    }

    public void setMinimum(double value) {
        this.m_Minimum = value;
        this.reset();
    }

    public double getMinimum() {
        return this.m_Minimum;
    }

    public String minimumTipText() {
        return "The minimum value that the values must satisfy; use NaN (not a number) to ignore minimum.";
    }

    public void setMinimumIncluded(boolean value) {
        this.m_MinimumIncluded = value;
        this.reset();
    }

    public boolean getMinimumIncluded() {
        return this.m_MinimumIncluded;
    }

    public String minimumIncludedTipText() {
        return "If enabled, then the minimum value gets included (testing '<=' rather than '<').";
    }

    public void setMaximum(double value) {
        this.m_Maximum = value;
        this.reset();
    }

    public double getMaximum() {
        return this.m_Maximum;
    }

    public String maximumTipText() {
        return "The maximum value that the values must satisfy; use NaN (not a number) to ignore maximum.";
    }

    public void setMaximumIncluded(boolean value) {
        this.m_MaximumIncluded = value;
        this.reset();
    }

    public boolean getMaximumIncluded() {
        return this.m_MaximumIncluded;
    }

    public String maximumIncludedTipText() {
        return "If enabled, then the maximum value gets included (testing '>=' rather than '>').";
    }

    public void setLabel(String value) {
        this.m_Label = value;
        this.reset();
    }

    public String getLabel() {
        return this.m_Label;
    }

    public String labelTipText() {
        return "The optional label to use; otherwise min/max are used to construct label.";
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"minimum", (Object)this.m_Minimum, (String)"min: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"minimumIncluded", (Object)(this.m_MinimumIncluded ? "incl" : "excl")) + "]";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"maximum", (Object)this.m_Maximum, (String)", max: ");
        result = result + " [" + QuickInfoHelper.toString((OptionHandler)this, (String)"maximumIncluded", (Object)(this.m_MaximumIncluded ? "incl" : "excl")) + "]";
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"label", (Object)(this.m_Label.isEmpty() ? "automatic" : this.m_Label), (String)", label: ");
        result = result + ", " + super.getQuickInfo();
        return result;
    }

    @Override
    public Class getDatasetFormat() {
        return this.m_Converter.getDatasetFormat();
    }

    @Override
    public Class getRowFormat() {
        return this.m_Converter.getRowFormat();
    }

    @Override
    public HeaderDefinition createHeader(Heatmap map) {
        String name;
        if (this.m_Label.isEmpty()) {
            name = this.m_MinimumIncluded ? "[" : "(";
            name = name + (Double.isNaN(this.m_Minimum) ? "-Inf" : Double.valueOf(this.m_Minimum)) + ";" + (Double.isNaN(this.m_Maximum) ? "+Inf" : Double.valueOf(this.m_Maximum));
            name = this.m_MaximumIncluded ? name + "]" : name + ")";
        } else {
            name = this.m_Label;
        }
        HeaderDefinition result = new HeaderDefinition();
        result.add(name, DataType.NUMERIC);
        return result;
    }

    @Override
    public List<Object>[] generateRows(Heatmap map) {
        List<Object>[] rows = this.m_Generator.generateRows(map);
        List[] result = new List[rows.length];
        for (int n = 0; n < rows.length; ++n) {
            ArrayList<Double> countData;
            List<Object> row = rows[n];
            int count = 0;
            result[n] = countData = new ArrayList<Double>();
            for (int i = 0; i < row.size(); ++i) {
                if (!(row.get(i) instanceof Number)) continue;
                double value = ((Number)row.get(i)).doubleValue();
                boolean use = true;
                if (!Double.isNaN(this.m_Minimum)) {
                    if (this.m_MinimumIncluded) {
                        if (value < this.m_Minimum) {
                            use = false;
                        }
                    } else if (value <= this.m_Minimum) {
                        use = false;
                    }
                }
                if (!Double.isNaN(this.m_Maximum)) {
                    if (this.m_MaximumIncluded) {
                        if (value > this.m_Maximum) {
                            use = false;
                        }
                    } else if (value >= this.m_Maximum) {
                        use = false;
                    }
                }
                if (!use) continue;
                ++count;
            }
            countData.add(new Double(count));
        }
        return result;
    }
}

