/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class NewHeatmap
extends AbstractSimpleSource {
    private static final long serialVersionUID = 393593515796397502L;
    protected int m_Rows;
    protected int m_Columns;
    protected double m_Value;
    protected String m_ID;

    public String globalInfo() {
        return "Creates a new heatmap of the specified size and fills it with the initial value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("rows", "rows", (Object)240, (Number)1, null);
        this.m_OptionManager.add("cols", "columns", (Object)320, (Number)1, null);
        this.m_OptionManager.add("value", "value", (Object)0.0);
        this.m_OptionManager.add("id", "ID", (Object)"");
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"rows", (Object)this.m_Rows, (String)"rows: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"columns", (Object)this.m_Columns, (String)", cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)", value: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"ID", (Object)("'" + this.m_ID + "'"), (String)", ID: ");
        return result;
    }

    public void setRows(int value) {
        this.m_Rows = value;
        this.reset();
    }

    public int getRows() {
        return this.m_Rows;
    }

    public String rowsTipText() {
        return "The number of rows.";
    }

    public void setColumns(int value) {
        this.m_Columns = value;
        this.reset();
    }

    public int getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The number of columns.";
    }

    public void setValue(double value) {
        this.m_Value = value;
        this.reset();
    }

    public double getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The initial value to set.";
    }

    public void setID(String value) {
        this.m_ID = value;
        this.reset();
    }

    public String getID() {
        return this.m_ID;
    }

    public String IDTipText() {
        return "The ID of the heatmap.";
    }

    public Class[] generates() {
        return new Class[]{Heatmap.class};
    }

    protected String doExecute() {
        String result = null;
        try {
            Heatmap map = new Heatmap(this.m_Rows, this.m_Columns);
            map.setID(this.m_ID);
            for (int i = 0; i < map.size(); ++i) {
                map.set(i, this.m_Value);
            }
            this.m_OutputToken = new Token((Object)map);
        }
        catch (Exception e) {
            result = this.handleException("Failed to initialize heatmap", e);
        }
        return result;
    }
}

