/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.io.PlaceholderFile;
import adams.data.filter.AbstractFilterTestCase;
import adams.data.filter.Filter;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.SpreadSheetHeatmapReader;
import adams.data.report.Report;
import adams.test.TmpFile;
import java.util.List;

public abstract class AbstractHeatmapFilterTestCase
extends AbstractFilterTestCase<Filter, Heatmap> {
    public AbstractHeatmapFilterTestCase(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        String[] files;
        super.setUp();
        for (String file : files = this.getRegressionInputFiles()) {
            this.m_TestHelper.copyResourceToTmp(file);
        }
    }

    protected void tearDown() throws Exception {
        String[] files;
        for (String file : files = this.getRegressionInputFiles()) {
            this.m_TestHelper.deleteFileFromTmp(file);
        }
        super.tearDown();
    }

    protected Heatmap load(String filename) {
        SpreadSheetHeatmapReader reader = new SpreadSheetHeatmapReader();
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        List heatmaps = reader.read();
        if (heatmaps.size() > 0) {
            return (Heatmap)heatmaps.get(0);
        }
        return null;
    }

    protected boolean save(Heatmap data, String filename) {
        StringBuilder content = new StringBuilder(data.toIntensityString());
        content.append("\n");
        Report report = data.getReport().getClone();
        report.setStringValue("Filename", "-");
        content.append(report.toString());
        return this.m_TestHelper.save((Object)content.toString(), filename);
    }
}

