/*
 * Decompiled with CFR 0.152.
 */
package adams.data.featuregenerator;

import adams.core.ClassLister;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.Report;

public abstract class AbstractFeatureGenerator
extends AbstractOptionHandler
implements Comparable,
ShallowCopySupporter<AbstractFeatureGenerator> {
    private static final long serialVersionUID = -7572598575382208115L;
    public static final String PREFIX_FEATURE = "Feature";
    protected String m_Prefix;

    protected void reset() {
        super.reset();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("prefix", "prefix", (Object)this.getDefaultPrefix());
    }

    protected String getDefaultPrefix() {
        return PREFIX_FEATURE;
    }

    public void setPrefix(String value) {
        this.m_Prefix = value;
        this.reset();
    }

    public String getPrefix() {
        return this.m_Prefix;
    }

    public String prefixTipText() {
        return "The prefix to use in the field for the generated features.";
    }

    public void cleanUp() {
        this.reset();
    }

    public Heatmap generate(Heatmap data) {
        this.checkData(data);
        Heatmap result = this.processData(data);
        return result;
    }

    protected void checkData(Heatmap data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected Double addFeature(Heatmap data, double value) {
        return this.addFeature(data, this.getClass().getName().replaceAll(".*\\.", ""), value);
    }

    protected Double addFeature(Heatmap data, String suffix, double value) {
        Double result = null;
        if (!data.hasReport()) {
            return result;
        }
        Report report = data.getReport();
        Field field = new Field(this.m_Prefix + "\t" + suffix, DataType.NUMERIC);
        report.addField((AbstractField)field);
        if (report.hasValue((AbstractField)field)) {
            result = report.getDoubleValue((AbstractField)field);
        }
        report.setValue((AbstractField)field, (Object)value);
        return result;
    }

    protected abstract Heatmap processData(Heatmap var1);

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine((Object)this).compareTo(OptionUtils.getCommandLine((Object)o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public AbstractFeatureGenerator shallowCopy() {
        return this.shallowCopy(false);
    }

    public AbstractFeatureGenerator shallowCopy(boolean expand) {
        return (AbstractFeatureGenerator)OptionUtils.shallowCopy((OptionHandler)this, (boolean)expand);
    }

    public static String[] getGenerators() {
        return ClassLister.getSingleton().getClassnames(AbstractFeatureGenerator.class);
    }

    public static AbstractFeatureGenerator forName(String classname, String[] options) {
        AbstractFeatureGenerator result;
        try {
            result = (AbstractFeatureGenerator)OptionUtils.forName(AbstractFeatureGenerator.class, (String)classname, (String[])options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractFeatureGenerator forCommandLine(String cmdline) {
        return (AbstractFeatureGenerator)AbstractOptionConsumer.fromString(ArrayConsumer.class, (String)cmdline);
    }
}

