/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.featuregenerator.AbstractFeatureGenerator;
import adams.data.featuregenerator.PassThrough;
import adams.data.filter.AbstractDatabaseConnectionFilter;
import adams.data.heatmap.Heatmap;
import adams.db.AbstractDatabaseConnection;
import adams.db.DatabaseConnection;
import adams.db.DatabaseConnectionHandler;

public class HeatmapFeatureGenerator
extends AbstractDatabaseConnectionFilter<Heatmap> {
    private static final long serialVersionUID = -754895778604425899L;
    protected AbstractFeatureGenerator m_Generator;

    public String globalInfo() {
        return "A filter that adds features to the report. The supplied feature generator updates/modifies the report.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new PassThrough());
    }

    protected AbstractDatabaseConnection getDefaultDatabaseConnection() {
        return DatabaseConnection.getSingleton();
    }

    public void setGenerator(AbstractFeatureGenerator value) {
        this.m_Generator = value;
        this.updateDatabaseConnection();
        this.reset();
    }

    public AbstractFeatureGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for updating/modifying the report.";
    }

    protected void updateDatabaseConnection() {
        if (this.m_Generator instanceof DatabaseConnectionHandler) {
            ((DatabaseConnectionHandler)this.m_Generator).setDatabaseConnection(this.getDatabaseConnection());
        }
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = this.m_Generator.generate(data.getClone());
        this.m_Generator.cleanUp();
        return result;
    }
}

