/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter.heatmapcrop;

import adams.data.filter.Filter;
import adams.data.filter.HeatmapCentroid;
import adams.data.filter.HeatmapThreshold;
import adams.data.filter.heatmapcrop.AbstractFilteredHeatmapCrop;
import adams.data.heatmap.Heatmap;
import adams.data.report.AbstractField;
import adams.data.report.DataType;
import adams.data.report.Field;
import java.awt.Point;

public class CropToCentroid
extends AbstractFilteredHeatmapCrop {
    private static final long serialVersionUID = 8109859053628417241L;
    protected int m_Height;
    protected int m_Width;
    protected HeatmapCentroid m_Centroid;

    public String globalInfo() {
        return "Generates a cropped heatmap centered around the centroid calculated on the pre-filtered data.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("height", "height", (Object)240, (Number)1, null);
        this.m_OptionManager.add("width", "width", (Object)320, (Number)1, null);
        this.m_OptionManager.add("centroid", "centroid", (Object)new HeatmapCentroid());
    }

    @Override
    protected Filter getDefaultFilter() {
        return new HeatmapThreshold();
    }

    public void setHeight(int value) {
        if (value > 0) {
            this.m_Height = value;
            this.reset();
        } else {
            this.getLogger().severe("Height must be > 0, provided: " + value);
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public String heightTipText() {
        return "The height of the cropped region.";
    }

    public void setWidth(int value) {
        if (value > 0) {
            this.m_Width = value;
            this.reset();
        } else {
            this.getLogger().severe("Width must be > 0, provided: " + value);
        }
    }

    public int getWidth() {
        return this.m_Width;
    }

    public String widthTipText() {
        return "The width of the cropped region.";
    }

    public void setCentroid(HeatmapCentroid value) {
        this.m_Centroid = value;
        this.reset();
    }

    public HeatmapCentroid getCentroid() {
        return this.m_Centroid;
    }

    public String centroidTipText() {
        return "The centroid filter to use.";
    }

    @Override
    protected Heatmap doCrop(Heatmap filtered, Heatmap original) {
        HeatmapCentroid centroid = (HeatmapCentroid)this.m_Centroid.shallowCopy(true);
        Heatmap centered = (Heatmap)centroid.filter(filtered);
        centroid.destroy();
        int c_x = (int)Math.round(centered.getReport().getDoubleValue((AbstractField)new Field("Centroid.X", DataType.NUMERIC)));
        int c_y = (int)Math.round(centered.getReport().getDoubleValue((AbstractField)new Field("Centroid.Y", DataType.NUMERIC)));
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Centroid location (y,x): " + c_y + "," + c_x);
        }
        Heatmap result = CropToCentroid.crop(original, c_y, c_x, this.m_Height, this.m_Width);
        this.m_TopLeft = new Point(result.getReport().getDoubleValue("Crop.Left").intValue(), result.getReport().getDoubleValue("Crop.Top").intValue());
        this.m_BottomRight = new Point(result.getReport().getDoubleValue("Crop.Right").intValue(), result.getReport().getDoubleValue("Crop.Bottom").intValue());
        return result;
    }

    public static Heatmap crop(Heatmap original, int centroidY, int centroidX, int height, int width) {
        Heatmap result = original.getHeader(height, width);
        int start_x = centroidX - width / 2;
        int start_y = centroidY - height / 2;
        int end_x = start_x + width;
        int end_y = start_y + height;
        start_x = Math.max(0, start_x);
        start_y = Math.max(0, start_y);
        end_x = Math.min(original.getWidth(), end_x);
        end_y = Math.min(original.getHeight(), end_y);
        result.getReport().setNumericValue("Crop.Left", (double)start_x);
        result.getReport().setNumericValue("Crop.Top", (double)start_y);
        result.getReport().setNumericValue("Crop.Right", (double)end_x);
        result.getReport().setNumericValue("Crop.Bottom", (double)end_y);
        for (int y = start_y; y < end_y; ++y) {
            for (int x = start_x; x < end_x; ++x) {
                result.set(y - start_y, x - start_x, original.get(y, x));
            }
        }
        return result;
    }
}

