/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import adams.flow.transformer.multiheatmapoperation.AbstractMultiHeatmapOperation;
import adams.flow.transformer.multiheatmapoperation.PassThrough;

public class MultiHeatmapOperation
extends AbstractTransformer {
    private static final long serialVersionUID = 3363405805013155845L;
    protected AbstractMultiHeatmapOperation m_Operation;

    public String globalInfo() {
        return "Applies the specified operation the incoming heatmap array.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("operation", "operation", (Object)new PassThrough());
    }

    public void setOperation(AbstractMultiHeatmapOperation value) {
        this.m_Operation = value;
        this.reset();
    }

    public AbstractMultiHeatmapOperation getOperation() {
        return this.m_Operation;
    }

    public String operationTipText() {
        return "The operation to apply to the incoming heatmaps.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"operation", (Object)((Object)this.m_Operation), (String)"operation: ");
    }

    public Class[] accepts() {
        return new Class[]{Heatmap[].class};
    }

    public Class[] generates() {
        return new Class[]{this.m_Operation.generates()};
    }

    protected String doExecute() {
        String result = null;
        Heatmap[] maps = null;
        if (this.m_InputToken.hasPayload(Heatmap[].class)) {
            maps = (Heatmap[])this.m_InputToken.getPayload(Heatmap[].class);
        } else {
            result = this.m_InputToken.unhandledData();
        }
        if (result == null) {
            MessageCollection errors = new MessageCollection();
            try {
                Object output = this.m_Operation.process(maps, errors);
                if (!errors.isEmpty()) {
                    result = errors.toString();
                } else {
                    this.m_OutputToken = new Token(output);
                }
            }
            catch (Exception e) {
                result = this.handleException("Failed to process spreadsheets using: " + this.m_Operation.toCommandLine(), e);
            }
        }
        return result;
    }
}

