/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multiheatmapoperation;

import adams.core.MessageCollection;
import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.flow.transformer.multiheatmapoperation.AbstractMultiHeatmapOperation;

public class AddConstant
extends AbstractMultiHeatmapOperation<Heatmap[]> {
    private static final long serialVersionUID = 6124767252812041585L;
    protected double m_Value;

    public String globalInfo() {
        return "Adds the specified constant value to all cells in the heatmaps.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("value", "value", (Object)0.0);
    }

    public void setValue(double value) {
        this.m_Value = value;
        this.reset();
    }

    public double getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The constant value to add to the cells.";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)"value: ");
    }

    @Override
    public int minNumSheetsRequired() {
        return 1;
    }

    @Override
    public int maxNumSheetsRequired() {
        return 0;
    }

    @Override
    public Class generates() {
        return Heatmap[].class;
    }

    @Override
    protected Heatmap[] doProcess(Heatmap[] maps, MessageCollection errors) {
        Heatmap[] result = new Heatmap[maps.length];
        for (int i = 0; i < maps.length; ++i) {
            result[i] = maps[i].getClone();
            for (int y = 0; y < maps[i].getHeight(); ++y) {
                for (int x = 0; x < maps[i].getWidth(); ++x) {
                    maps[i].set(y, x, maps[i].get(y, x) + this.m_Value);
                }
            }
        }
        return result;
    }
}

