/*
 * Decompiled with CFR 0.152.
 */
package adams.data.heatmapfeatures;

import adams.core.Utils;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.data.heatmap.Heatmap;
import adams.data.heatmapfeatures.AbstractHeatmapFeatureGenerator;
import adams.data.io.input.AbstractHeatmapReader;
import adams.test.AbstractDatabaseTestCase;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractHeatmapFeatureGeneratorTestCase
extends AbstractDatabaseTestCase {
    public AbstractHeatmapFeatureGeneratorTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/heatmapfeatures/data");
    }

    protected List<Heatmap> load(String filename, AbstractHeatmapReader reader) {
        this.m_TestHelper.copyResourceToTmp(filename);
        reader.setInput((PlaceholderFile)new TmpFile(filename));
        List result = reader.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected List<List<Object>[]> process(AbstractHeatmapFeatureGenerator generator, List<Heatmap> data) {
        ArrayList<List<Object>[]> result = new ArrayList<List<Object>[]>();
        for (Heatmap map : data) {
            result.add(generator.generateRows(map));
        }
        return result;
    }

    protected String toString(Object obj) {
        if (obj == null) {
            return "?";
        }
        if (obj instanceof Number) {
            return Utils.doubleToStringFixed((double)((Number)obj).doubleValue(), (int)6);
        }
        return obj.toString();
    }

    protected boolean save(List<List<Object>[]> data, String filename, int[] ignored) {
        StringBuilder output = new StringBuilder();
        for (int i = 0; i < data.size(); ++i) {
            output.append("#" + (i + 1) + ":\n");
            for (List<Object> row : data.get(i)) {
                for (int n = 0; n < row.size(); ++n) {
                    if (n > 0) {
                        output.append(",");
                    }
                    output.append(this.toString(row.get(n)));
                }
                output.append("\n");
            }
            output.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)output, (boolean)false);
    }

    protected String[] getRegressionConnections() {
        return null;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractHeatmapReader[] getRegressionInputFileReaders();

    protected abstract AbstractHeatmapFeatureGenerator[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
            result = (String)result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        AbstractHeatmapReader[] readers = this.getRegressionInputFileReaders();
        String[] output = new String[input.length];
        AbstractHeatmapFeatureGenerator[] setups = this.getRegressionSetups();
        int[] ignored = this.getRegressionIgnoredLineIndices();
        String[] props = this.getRegressionConnections();
        AbstractHeatmapFeatureGeneratorTestCase.assertEquals((String)"Number of files and readers differ!", (int)input.length, (int)readers.length);
        AbstractHeatmapFeatureGeneratorTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        if (props != null) {
            AbstractHeatmapFeatureGeneratorTestCase.assertEquals((String)"Number of files and connection setups differ!", (int)input.length, (int)props.length);
        } else {
            props = new String[input.length];
            for (i = 0; i < props.length; ++i) {
                props[i] = this.getDatabasePropertiesFile();
            }
        }
        for (i = 0; i < input.length; ++i) {
            this.reconnect(props[i]);
            AbstractHeatmapFeatureGenerator current = (AbstractHeatmapFeatureGenerator)OptionUtils.shallowCopy((OptionHandler)setups[i], (boolean)false);
            AbstractHeatmapFeatureGeneratorTestCase.assertNotNull((String)("Failed to create copy of algorithm: " + OptionUtils.getCommandLine((Object)setups[i])), (Object)current);
            List<Heatmap> data = this.load(input[i], readers[i]);
            AbstractHeatmapFeatureGeneratorTestCase.assertNotNull((String)"Failed to read data?", data);
            List<List<Object>[]> processed = this.process(current, data);
            AbstractHeatmapFeatureGeneratorTestCase.assertNotNull((String)"Failed to process data?", processed);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(processed, output[i], ignored);
            AbstractHeatmapFeatureGeneratorTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
            current.destroy();
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles);
        AbstractHeatmapFeatureGeneratorTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            setups[i].destroy();
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
        this.cleanUpAfterRegression();
        this.m_Properties = null;
        this.getDatabaseProperties();
    }

    protected void cleanUpAfterRegression() {
    }
}

