/*
 * Decompiled with CFR 0.152.
 */
package adams.data.io.input;

import adams.core.CleanUpHandler;
import adams.core.Destroyable;
import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.data.heatmap.Heatmap;
import adams.data.io.input.AbstractHeatmapReader;
import adams.test.AbstractTestHelper;
import adams.test.AdamsTestCase;
import adams.test.TestHelper;
import adams.test.TmpFile;
import java.io.File;
import java.util.List;

public abstract class AbstractHeatmapReaderTestCase
extends AdamsTestCase {
    public AbstractHeatmapReaderTestCase(String name) {
        super(name);
    }

    protected AbstractTestHelper newTestHelper() {
        return new TestHelper((AdamsTestCase)this, "adams/data/io/input/data");
    }

    protected List<Heatmap> load(String filename, AbstractHeatmapReader scheme) {
        scheme.setUseAbsoluteSource(false);
        this.m_TestHelper.copyResourceToTmp(filename);
        scheme.setInput((PlaceholderFile)new TmpFile(filename));
        List result = scheme.read();
        this.m_TestHelper.deleteFileFromTmp(filename);
        return result;
    }

    protected abstract String[] getRegressionInputFiles();

    protected abstract AbstractHeatmapReader[] getRegressionSetups();

    protected int[] getRegressionIgnoredLineIndices() {
        return new int[0];
    }

    protected boolean save(List<Heatmap> data, String filename) {
        StringBuilder content = new StringBuilder();
        for (Heatmap map : data) {
            content.append(map.toIntensityString());
            content.append("\n");
        }
        return FileUtils.writeToFile((String)new TmpFile(filename).getAbsolutePath(), (Object)content, (boolean)false);
    }

    protected String createOutputFilename(String input, int no) {
        Object result;
        String ext = "-out" + no;
        int index = input.lastIndexOf(46);
        if (index == -1) {
            result = input + ext;
        } else {
            result = input.substring(0, index);
            result = (String)result + ext;
            result = (String)result + input.substring(index);
        }
        return result;
    }

    public void testRegression() {
        int i;
        if (this.m_NoRegressionTest) {
            return;
        }
        String[] input = this.getRegressionInputFiles();
        String[] output = new String[input.length];
        AbstractHeatmapReader[] setups = this.getRegressionSetups();
        AbstractHeatmapReaderTestCase.assertEquals((String)"Number of files and setups differ!", (int)input.length, (int)setups.length);
        for (i = 0; i < input.length; ++i) {
            List<Heatmap> data = this.load(input[i], setups[i]);
            AbstractHeatmapReaderTestCase.assertNotNull((String)"Failed to load data?", data);
            output[i] = this.createOutputFilename(input[i], i);
            boolean ok = this.save(data, output[i]);
            AbstractHeatmapReaderTestCase.assertTrue((String)"Failed to save regression data?", (boolean)ok);
        }
        TmpFile[] outputFiles = new TmpFile[output.length];
        for (i = 0; i < output.length; ++i) {
            outputFiles[i] = new TmpFile(output[i]);
        }
        String regression = this.m_Regression.compare((File[])outputFiles, this.getRegressionIgnoredLineIndices());
        AbstractHeatmapReaderTestCase.assertNull((String)("Output differs:\n" + regression), (Object)regression);
        for (i = 0; i < output.length; ++i) {
            if (setups[i] instanceof Destroyable) {
                setups[i].destroy();
            } else if (setups[i] instanceof CleanUpHandler) {
                setups[i].cleanUp();
            }
            this.m_TestHelper.deleteFileFromTmp(output[i]);
        }
    }
}

