/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.heatmap.Heatmap;
import adams.data.spreadsheet.SpreadSheet;
import adams.data.spreadsheet.SpreadSheetColumnRange;
import adams.data.spreadsheet.SpreadSheetHelper;
import adams.data.statistics.StatUtils;
import java.util.ArrayList;

public class ColumnCorrelationToHeatmap
extends AbstractConversion {
    private static final long serialVersionUID = 4705676366087704263L;
    protected SpreadSheetColumnRange m_Columns;

    public String globalInfo() {
        return "Computes the correlation coefficients between the specified range of columns and outputs a heatmap with the calculated values.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("columns", "columns", (Object)new SpreadSheetColumnRange("first-last"));
    }

    public void setColumns(SpreadSheetColumnRange value) {
        this.m_Columns = value;
        this.reset();
    }

    public SpreadSheetColumnRange getColumns() {
        return this.m_Columns;
    }

    public String columnsTipText() {
        return "The columns to include in the calculations.";
    }

    public Class accepts() {
        return SpreadSheet.class;
    }

    public Class generates() {
        return Heatmap.class;
    }

    protected Object doConvert() throws Exception {
        int i;
        SpreadSheet sheet = (SpreadSheet)this.m_Input;
        this.m_Columns.setData((Object)sheet);
        int[] cols = this.m_Columns.getIntIndices();
        if (cols.length == 0) {
            throw new IllegalStateException("Failed to determine any columns using: " + this.m_Columns.getRange());
        }
        ArrayList<double[]> values = new ArrayList<double[]>();
        for (i = 0; i < cols.length; ++i) {
            if (!sheet.isNumeric(cols[i])) continue;
            values.add(SpreadSheetHelper.getNumericColumn((SpreadSheet)sheet, (int)cols[i]));
        }
        Heatmap result = new Heatmap(values.size(), values.size());
        for (i = 0; i < cols.length; ++i) {
            for (int n = i; n < cols.length; ++n) {
                double cc = StatUtils.correlationCoefficient((double[])((double[])values.get(i)), (double[])((double[])values.get(n)));
                result.set(i, n, cc);
            }
        }
        return result;
    }
}

