/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.data.conversion.AbstractConversion;
import adams.data.conversion.HeatmapToBufferedImageConversion;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.core.ColorGradientGenerator;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class HeatmapToBufferedImage
extends AbstractConversion
implements HeatmapToBufferedImageConversion {
    private static final long serialVersionUID = 2535421741524997185L;
    protected ColorGradientGenerator m_Generator;
    protected Color m_MissingValueColor;
    protected boolean m_UseFixedRange;
    protected double m_Min;
    protected double m_Max;
    protected Color[] m_GradientColors;

    public String globalInfo() {
        return "Turns a heatmap into a BufferedImage.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new BiColorGenerator());
        this.m_OptionManager.add("missing-value-color", "missingValueColor", (Object)new Color(255, 255, 255, 0));
        this.m_OptionManager.add("use-fixed-range", "useFixedRange", (Object)false);
        this.m_OptionManager.add("min", "min", (Object)0.0);
        this.m_OptionManager.add("max", "max", (Object)100.0);
    }

    protected void reset() {
        super.reset();
        this.m_GradientColors = null;
    }

    public void setGenerator(ColorGradientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public ColorGradientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for creating the gradient colors.";
    }

    public void setMissingValueColor(Color value) {
        this.m_MissingValueColor = value;
        this.reset();
    }

    public Color getMissingValueColor() {
        return this.m_MissingValueColor;
    }

    public String missingValueColorTipText() {
        return "The color to use for missing values.";
    }

    public void setUseFixedRange(boolean value) {
        this.m_UseFixedRange = value;
        this.reset();
    }

    public boolean getUseFixedRange() {
        return this.m_UseFixedRange;
    }

    public String useFixedRangeTipText() {
        return "Whether to use pre-defined min/max values or ones determined from the heatmap itself.";
    }

    public void setMin(double value) {
        this.m_Min = value;
        this.reset();
    }

    public double getMin() {
        return this.m_Min;
    }

    public String minTipText() {
        return "The minimum to use in case of using a fixed range.";
    }

    public void setMax(double value) {
        this.m_Max = value;
        this.reset();
    }

    public double getMax() {
        return this.m_Max;
    }

    public String maxTipText() {
        return "The maximum to use in case of using a fixed range.";
    }

    public Class accepts() {
        return Heatmap.class;
    }

    public Class generates() {
        return AbstractImageContainer.class;
    }

    protected Color[] getGradientColors() {
        if (this.m_GradientColors == null) {
            this.m_GradientColors = this.m_Generator.generate();
        }
        return this.m_GradientColors;
    }

    protected String checkData() {
        Object result = super.checkData();
        if (result == null && this.m_UseFixedRange && this.m_Min >= this.m_Max) {
            result = "Max must be greater than Min: max=" + this.m_Max + ", min=" + this.m_Min;
        }
        return result;
    }

    protected Object doConvert() throws Exception {
        double max;
        double min;
        Heatmap map = (Heatmap)this.m_Input;
        if (this.m_UseFixedRange) {
            min = this.m_Min;
            max = this.m_Max;
        } else {
            min = map.getMin();
            max = map.getMax();
            if (max == min) {
                max = min + 1.0;
                this.getLogger().warning("Max/min are the same, using min=" + min + ", max=" + max + " instead!");
            }
        }
        Color[] colors = this.getGradientColors();
        double range = max - min;
        BufferedImage image = new BufferedImage(map.getWidth(), map.getHeight(), 1);
        Graphics2D g = image.createGraphics();
        for (int y = 0; y < map.getHeight(); ++y) {
            for (int x = 0; x < map.getWidth(); ++x) {
                Color color = map.isMissing(y, x) ? this.m_MissingValueColor : colors[(int)((map.get(y, x) - min) / range * (double)(colors.length - 2)) + 1];
                g.setColor(color);
                g.drawLine(x, y, x, y);
            }
        }
        BufferedImageContainer result = new BufferedImageContainer();
        result.setImage((Object)image);
        return result;
    }

    @Override
    public double grayToIntensity(Heatmap map, int gray) {
        double max;
        double min;
        if (this.m_UseFixedRange) {
            min = this.m_Min;
            max = this.m_Max;
        } else {
            min = map.getMin();
            max = map.getMax();
            if (max == min) {
                max = min + 1.0;
                this.getLogger().warning("Max/min are the same, using min=" + min + ", max=" + max + " instead!");
            }
        }
        double range = max - min;
        double result = min + range * ((double)gray / 256.0);
        return result;
    }
}

