/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.annotation.ThirdPartyCopyright;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.HeatmapToBufferedImageConversion;
import adams.data.heatmap.Heatmap;
import adams.data.image.AbstractImageContainer;
import adams.data.image.BufferedImageContainer;
import adams.gui.visualization.core.BiColorGenerator;
import adams.gui.visualization.core.ColorGradientGenerator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;

@ThirdPartyCopyright(author="Michael Fowke", copyright="2014 Soilcares Research, Wageningen, The Netherlands")
public class HeatmapToBufferedImageWithKey
extends AbstractConversion
implements HeatmapToBufferedImageConversion {
    private static final long serialVersionUID = -9065168080375023679L;
    protected ColorGradientGenerator m_Generator;
    protected boolean m_UseCustomRange;
    protected double m_MinRange;
    protected double m_MaxRange;
    protected boolean m_ShowKey;
    protected int m_ScaleFactor;
    protected Color m_MissingColor;
    protected Color[] m_GradientColors;

    public String globalInfo() {
        return "Turns a heatmap into a BufferedImage, allows the generation of a key in the image.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("generator", "generator", (Object)new BiColorGenerator());
        this.m_OptionManager.add("use-custom-range", "useCustomRange", (Object)false);
        this.m_OptionManager.add("min-range", "minRange", (Object)-1.0);
        this.m_OptionManager.add("max-range", "maxRange", (Object)100.0);
        this.m_OptionManager.add("show-key", "showKey", (Object)false);
        this.m_OptionManager.add("scale-factor", "scaleFactor", (Object)1);
        this.m_OptionManager.add("missing-color", "missingColor", (Object)Color.WHITE);
    }

    protected void reset() {
        super.reset();
        this.m_GradientColors = null;
    }

    public void setGenerator(ColorGradientGenerator value) {
        this.m_Generator = value;
        this.reset();
    }

    public ColorGradientGenerator getGenerator() {
        return this.m_Generator;
    }

    public String generatorTipText() {
        return "The generator to use for creating the gradient colors.";
    }

    public void setUseCustomRange(boolean value) {
        this.m_UseCustomRange = value;
        this.reset();
    }

    public boolean getUseCustomRange() {
        return this.m_UseCustomRange;
    }

    public String useCustomRangeTipText() {
        return "Whether to use a custom user defined range rather than the range from the incoming heatmap";
    }

    public void setMinRange(double value) {
        this.m_MinRange = value;
        this.reset();
    }

    public double getMinRange() {
        return this.m_MinRange;
    }

    public String minRangeTipText() {
        return "the minimum value of the heatmap colour range";
    }

    public void setMaxRange(double value) {
        this.m_MaxRange = value;
        this.reset();
    }

    public double getMaxRange() {
        return this.m_MaxRange;
    }

    public String maxRangeTipText() {
        return "the maximum value to use in the colour range";
    }

    public void setShowKey(boolean value) {
        this.m_ShowKey = value;
        this.reset();
    }

    public boolean getShowKey() {
        return this.m_ShowKey;
    }

    public String showKeyTipText() {
        return "Whether to display a key displaying the values corresponding to certain colours on the heatmap";
    }

    public void setScaleFactor(int val) {
        this.m_ScaleFactor = val;
        this.reset();
    }

    public int getScaleFactor() {
        return this.m_ScaleFactor;
    }

    public String scaleFactorTipText() {
        return "scale factor with which to increase the size of the heatmap image";
    }

    public void setMissingColor(Color val) {
        this.m_MissingColor = val;
        this.reset();
    }

    public Color getMissingColor() {
        return this.m_MissingColor;
    }

    public String missingColorTipText() {
        return "The color to use if a value in the heatmap is missing";
    }

    public Class accepts() {
        return Heatmap.class;
    }

    public Class generates() {
        return AbstractImageContainer.class;
    }

    protected Color[] getGradientColors() {
        if (this.m_GradientColors == null) {
            this.m_GradientColors = this.m_Generator.generate();
        }
        return this.m_GradientColors;
    }

    protected Object doConvert() throws Exception {
        int x;
        int y;
        double max;
        double min;
        Heatmap map = (Heatmap)this.m_Input;
        Color[] colors = this.getGradientColors();
        if (this.m_UseCustomRange) {
            min = this.m_MinRange;
            max = this.m_MaxRange;
        } else {
            min = Double.MAX_VALUE;
            max = Double.MIN_VALUE;
            for (y = 0; y < map.getHeight(); ++y) {
                for (x = 0; x < map.getWidth(); ++x) {
                    if (map.get(y, x) > 0.0) {
                        min = Math.min(map.get(y, x), min);
                    }
                    max = Math.max(map.get(y, x), max);
                }
            }
        }
        double range = max - min;
        BufferedImage image = null;
        if (this.m_ShowKey) {
            Color color;
            int spaceTop = 10;
            int spaceBottom = 10;
            int keyWidth = 20;
            int afterHeatMap = 20;
            int afterKey = 50;
            int tickWidth = 10;
            int endHeatMap = map.getWidth() * this.m_ScaleFactor;
            int heightMap = map.getHeight() * this.m_ScaleFactor;
            int totalHeight = map.getHeight() * this.m_ScaleFactor + spaceTop + spaceBottom;
            int endFirstWhite = endHeatMap + afterHeatMap;
            int endKey = endFirstWhite + keyWidth;
            int totalWidth = endKey + afterKey;
            int startText = endKey + tickWidth;
            image = new BufferedImage(totalWidth, totalHeight, 1);
            Graphics2D g = image.createGraphics();
            g.setColor(Color.WHITE);
            g.fillRect(0, 0, totalWidth, totalHeight);
            for (y = 0; y < map.getHeight(); ++y) {
                for (x = 0; x < map.getWidth(); ++x) {
                    color = map.get(y, x) == 0.0 || map.isMissing(y, x) ? this.m_MissingColor : colors[(int)((map.get(y, x) - min) / range * (double)(colors.length - 2)) + 1];
                    g.setColor(color);
                    g.fillRect(x * this.m_ScaleFactor, y * this.m_ScaleFactor + spaceTop, this.m_ScaleFactor, this.m_ScaleFactor);
                }
            }
            for (int i = 0; i < heightMap; ++i) {
                double percen = (double)i / (double)heightMap;
                double index = percen * (double)(colors.length - 2) + 1.0;
                color = colors[(int)index];
                g.setColor(color);
                g.drawLine(endFirstWhite, i + spaceTop, endKey, i + spaceTop);
            }
            g.setColor(Color.BLACK);
            g.drawRect(endFirstWhite, spaceTop, keyWidth, heightMap);
            int numTicks = 3;
            Font curF = g.getFont();
            Font newF = new Font(curF.getName(), 0, curF.getSize() - 2);
            g.setFont(newF);
            for (int i = 0; i < numTicks; ++i) {
                double segment = heightMap / (numTicks - 1);
                double val = (max - min) * (double)i / 2.0 + min;
                DecimalFormat df = new DecimalFormat("#.###");
                String valFormatted = df.format(val);
                g.drawLine(endKey, (int)(segment * (double)i) + spaceTop, startText, (int)(segment * (double)i) + spaceTop);
                g.drawString(valFormatted, (float)startText, (float)(segment * (double)i + (double)spaceTop));
            }
        } else {
            image = new BufferedImage(map.getWidth() * this.m_ScaleFactor, map.getHeight() * this.m_ScaleFactor, 1);
            Graphics2D g = image.createGraphics();
            for (y = 0; y < map.getHeight(); ++y) {
                for (x = 0; x < map.getWidth(); ++x) {
                    Color color = map.get(y, x) == 0.0 ? this.m_MissingColor : colors[(int)((map.get(y, x) - min) / range * (double)(colors.length - 2)) + 1];
                    g.setColor(color);
                    g.fillRect(x * this.m_ScaleFactor, y * this.m_ScaleFactor, this.m_ScaleFactor, this.m_ScaleFactor);
                }
            }
        }
        BufferedImageContainer result = new BufferedImageContainer();
        result.setImage((Object)image);
        return result;
    }

    @Override
    public double grayToIntensity(Heatmap map, int gray) {
        double max;
        double min;
        if (this.m_UseCustomRange) {
            min = this.m_MinRange;
            max = this.m_MaxRange;
        } else {
            min = map.getMin();
            max = map.getMax();
            if (max == min) {
                max = min + 1.0;
                this.getLogger().warning("Max/min are the same, using min=" + min + ", max=" + max + " instead!");
            }
        }
        double range = max - min;
        double result = min + range * ((double)gray / 256.0);
        return result;
    }
}

