/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.data.filter.AbstractFilter;
import adams.data.filter.heatmapthreshold.AbstractHeatmapThreshold;
import adams.data.filter.heatmapthreshold.Manual;
import adams.data.heatmap.Heatmap;

public class HeatmapThreshold
extends AbstractFilter<Heatmap> {
    private static final long serialVersionUID = -1306518673446335794L;
    protected Type m_Type;
    protected AbstractHeatmapThreshold m_Threshold;
    protected double m_Replacement;
    protected boolean m_ReplaceWithMissing;
    protected MissingValuesHandling m_MissingValuesHandling;

    public String globalInfo() {
        return "Replaces all intensity values that are either below or above a user-specified threshold, depending on the selected threshold type, using the pre-defined replacement value.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)Type.BELOW);
        this.m_OptionManager.add("threshold", "threshold", (Object)new Manual());
        this.m_OptionManager.add("replacement", "replacement", (Object)-1.0);
        this.m_OptionManager.add("replace-with-missing", "replaceWithMissing", (Object)false);
        this.m_OptionManager.add("missing-values-handling", "missingValuesHandling", (Object)MissingValuesHandling.SKIP);
    }

    public void setType(Type value) {
        this.m_Type = value;
        this.reset();
    }

    public Type getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of threshold to use: if " + Type.BELOW + " then all values that fall below the threshold are zeroed, if " + Type.ABOVE + " then all values that are above the threshold are zeroed.";
    }

    public void setThreshold(AbstractHeatmapThreshold value) {
        this.m_Threshold = value;
        this.reset();
    }

    public AbstractHeatmapThreshold getThreshold() {
        return this.m_Threshold;
    }

    public String thresholdTipText() {
        return "The threshold algorithm to use.";
    }

    public void setReplacement(double value) {
        this.m_Replacement = value;
        this.reset();
    }

    public double getReplacement() {
        return this.m_Replacement;
    }

    public String replacementTipText() {
        return "The replacement value to use.";
    }

    public void setReplaceWithMissing(boolean value) {
        this.m_ReplaceWithMissing = value;
        this.reset();
    }

    public boolean getReplaceWithMissing() {
        return this.m_ReplaceWithMissing;
    }

    public String replaceWithMissingTipText() {
        return "If enabled, the values are replaced with missing values rather than actual values.";
    }

    public void setMissingValuesHandling(MissingValuesHandling value) {
        this.m_MissingValuesHandling = value;
        this.reset();
    }

    public MissingValuesHandling getMissingValuesHandling() {
        return this.m_MissingValuesHandling;
    }

    public String missingValuesHandlingTipText() {
        return "Determines how missing values are handled when processing the heatmap, eg whether they get skipped or always replaced.";
    }

    protected Heatmap processData(Heatmap data) {
        Heatmap result = data.getClone();
        double threshold = this.m_Threshold.calcThreshold(data);
        if (this.isLoggingEnabled()) {
            this.getLogger().info("Threshold: " + threshold);
        }
        block8: for (int i = 0; i < data.size(); ++i) {
            double value = data.get(i);
            if (Heatmap.isMissingValue(value)) {
                switch (this.m_MissingValuesHandling) {
                    case SKIP: {
                        continue block8;
                    }
                    case REPLACE: {
                        if (this.m_ReplaceWithMissing) continue block8;
                        result.set(i, this.m_Replacement);
                        continue block8;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled missing values handling: " + this.m_MissingValuesHandling);
                    }
                }
            }
            switch (this.m_Type) {
                case BELOW: {
                    if (!(value < threshold)) continue block8;
                    if (this.m_ReplaceWithMissing) {
                        result.setMissing(i);
                        continue block8;
                    }
                    result.set(i, this.m_Replacement);
                    continue block8;
                }
                case ABOVE: {
                    if (!(value > threshold)) continue block8;
                    if (this.m_ReplaceWithMissing) {
                        result.setMissing(i);
                        continue block8;
                    }
                    result.set(i, this.m_Replacement);
                    continue block8;
                }
                default: {
                    throw new IllegalStateException("Unhandled type: " + this.m_Type);
                }
            }
        }
        return result;
    }

    public static enum MissingValuesHandling {
        SKIP,
        REPLACE;

    }

    public static enum Type {
        ABOVE,
        BELOW;

    }
}

