/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.flow.transformer.AbstractArrayProvider;

public class HeatmapGetValue
extends AbstractArrayProvider {
    private static final long serialVersionUID = -253714973019682939L;
    protected Range m_Row;
    protected Range m_Column;

    public String globalInfo() {
        return "Extracts values from a heatmap.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Range("1"));
        this.m_OptionManager.add("col", "column", (Object)new Range("1"));
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Range();
        this.m_Column = new Range();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)this.m_Column, (String)"/col: ");
        return result;
    }

    protected Class getItemClass() {
        return Double.class;
    }

    public String outputArrayTipText() {
        return "Whether to output the values in an array or one-by-one.";
    }

    public void setRow(Range value) {
        this.m_Row = value;
        this.reset();
    }

    public Range getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row(s) of the value(s) to retrieve.";
    }

    public void setColumn(Range value) {
        this.m_Column = value;
        this.reset();
    }

    public Range getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column(s) of the value(s) to retrieve";
    }

    public Class[] accepts() {
        return new Class[]{Heatmap.class};
    }

    protected String doExecute() {
        String result = null;
        Heatmap map = (Heatmap)this.m_InputToken.getPayload();
        this.m_Row.setMax(map.getHeight());
        this.m_Column.setMax(map.getWidth());
        int[] rows = this.m_Row.getIntIndices();
        int[] cols = this.m_Column.getIntIndices();
        if (rows.length == 0) {
            result = "No row(s) selected?";
        } else if (cols.length == 0) {
            result = "No column(s) selected?";
        } else {
            for (int r : rows) {
                for (int c : cols) {
                    double value = map.get(r, c);
                    this.m_Queue.add(value);
                }
            }
        }
        return result;
    }
}

