/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.data.heatmap.HeatmapStatistic;
import adams.flow.core.DataInfoActor;
import adams.flow.transformer.AbstractArrayProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;

public class HeatmapInfo
extends AbstractArrayProvider
implements DataInfoActor {
    private static final long serialVersionUID = -3019442578354930841L;
    protected InfoType m_Type;

    public String globalInfo() {
        return "Outputs statistics of a heatmap object.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("type", "type", (Object)InfoType.WIDTH);
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"type", (Object)((Object)this.m_Type));
    }

    public String outputArrayTipText() {
        return "If enabled, the info items get output as array rather than one-by-one.";
    }

    public void setType(InfoType value) {
        this.m_Type = value;
        this.reset();
    }

    public InfoType getType() {
        return this.m_Type;
    }

    public String typeTipText() {
        return "The type of information to generate.";
    }

    protected Class getItemClass() {
        switch (this.m_Type) {
            case WIDTH: 
            case HEIGHT: 
            case ZEROES: 
            case NON_ZEROES: 
            case MISSING: {
                return Integer.class;
            }
            case MIN: 
            case MAX: 
            case VALUES: {
                return Double.class;
            }
        }
        throw new IllegalStateException("Unhandled info type: " + this.m_Type);
    }

    public Class[] accepts() {
        return new Class[]{Heatmap.class};
    }

    protected String doExecute() {
        String result = null;
        this.m_Queue = new ArrayList();
        Heatmap map = (Heatmap)this.m_InputToken.getPayload();
        switch (this.m_Type) {
            case WIDTH: {
                this.m_Queue.add(map.getWidth());
                break;
            }
            case HEIGHT: {
                this.m_Queue.add(map.getHeight());
                break;
            }
            case MIN: {
                this.m_Queue.add(map.getMin());
                break;
            }
            case MAX: {
                this.m_Queue.add(map.getMax());
                break;
            }
            case ZEROES: {
                HeatmapStatistic stats = map.toStatistic();
                this.m_Queue.add(stats.getStatistic(HeatmapStatistic.COUNT_ZEROES));
                break;
            }
            case NON_ZEROES: {
                HeatmapStatistic stats = map.toStatistic();
                this.m_Queue.add(stats.getStatistic(HeatmapStatistic.COUNT_NONZEROES));
                break;
            }
            case MISSING: {
                HeatmapStatistic stats = map.toStatistic();
                this.m_Queue.add(stats.getStatistic(HeatmapStatistic.COUNT_MISSING));
                break;
            }
            case VALUES: {
                HashSet<Double> values = new HashSet<Double>(Arrays.asList(map.toDoubleArray()));
                this.m_Queue.addAll(values);
                Collections.sort(this.m_Queue);
                break;
            }
            default: {
                result = "Unhandled info type: " + this.m_Type;
            }
        }
        return result;
    }

    public static enum InfoType {
        WIDTH,
        HEIGHT,
        MIN,
        MAX,
        ZEROES,
        NON_ZEROES,
        MISSING,
        VALUES;

    }
}

