/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.Range;
import adams.core.option.OptionHandler;
import adams.data.heatmap.Heatmap;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractInPlaceHeatmapTransformer;

public class HeatmapSetValue
extends AbstractInPlaceHeatmapTransformer {
    private static final long serialVersionUID = -6250232085303020849L;
    protected Range m_Row;
    protected Range m_Column;
    protected Double m_Value;

    public String globalInfo() {
        return "Sets the value of the specified positions in a heatmap.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("row", "row", (Object)new Range("1"));
        this.m_OptionManager.add("col", "column", (Object)new Range("1"));
        this.m_OptionManager.add("value", "value", (Object)0.0);
    }

    protected void initialize() {
        super.initialize();
        this.m_Row = new Range();
        this.m_Column = new Range();
    }

    public String getQuickInfo() {
        Object result = QuickInfoHelper.toString((OptionHandler)this, (String)"row", (Object)this.m_Row, (String)"row: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"column", (Object)this.m_Column, (String)"/col: ");
        result = (String)result + QuickInfoHelper.toString((OptionHandler)this, (String)"value", (Object)this.m_Value, (String)", value: ");
        return result;
    }

    public void setRow(Range value) {
        this.m_Row = value;
        this.reset();
    }

    public Range getRow() {
        return this.m_Row;
    }

    public String rowTipText() {
        return "The row(s) of the position(s) to set.";
    }

    public void setColumn(Range value) {
        this.m_Column = value;
        this.reset();
    }

    public Range getColumn() {
        return this.m_Column;
    }

    public String columnTipText() {
        return "The column(s) of the position(s) to set";
    }

    public void setValue(Double value) {
        this.m_Value = value;
        this.reset();
    }

    public Double getValue() {
        return this.m_Value;
    }

    public String valueTipText() {
        return "The value to set in the position(s).";
    }

    protected String doExecute() {
        String result = null;
        Heatmap map = (Heatmap)this.m_InputToken.getPayload();
        if (!this.m_NoCopy) {
            map = map.getClone();
        }
        this.m_Row.setMax(map.getHeight());
        this.m_Column.setMax(map.getWidth());
        int[] rows = this.m_Row.getIntIndices();
        int[] cols = this.m_Column.getIntIndices();
        if (rows.length == 0) {
            result = "No row(s) selected?";
        } else if (cols.length == 0) {
            result = "No column(s) selected?";
        } else {
            for (int r : rows) {
                for (int c : cols) {
                    map.set(r, c, this.m_Value);
                }
            }
            this.m_OutputToken = new Token((Object)map);
        }
        return result;
    }
}

