/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multiheatmapoperation;

import adams.core.MessageCollection;
import adams.core.QuickInfoSupporter;
import adams.core.option.AbstractOptionHandler;
import adams.data.heatmap.Heatmap;

public abstract class AbstractMultiHeatmapOperation<O>
extends AbstractOptionHandler
implements QuickInfoSupporter {
    private static final long serialVersionUID = 1185449853784824033L;

    public String getQuickInfo() {
        return null;
    }

    public abstract int minNumSheetsRequired();

    public abstract int maxNumSheetsRequired();

    public abstract Class generates();

    protected void check(Heatmap[] maps) {
        if (maps == null || maps.length == 0) {
            throw new IllegalStateException("No heatmaps provided!");
        }
        if (this.minNumSheetsRequired() > 0 && maps.length < this.minNumSheetsRequired()) {
            throw new IllegalStateException("Not enough heatmaps supplied (min > supplied): " + this.minNumSheetsRequired() + " > " + maps.length);
        }
        if (this.maxNumSheetsRequired() > 0 && maps.length > this.maxNumSheetsRequired()) {
            throw new IllegalStateException("Too many heatmaps supplied (max < supplied): " + this.maxNumSheetsRequired() + " < " + maps.length);
        }
    }

    protected abstract O doProcess(Heatmap[] var1, MessageCollection var2);

    public O process(Heatmap[] maps, MessageCollection errors) {
        this.check(maps);
        return this.doProcess(maps, errors);
    }
}

