/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer.multiheatmapoperation;

import adams.core.MessageCollection;
import adams.data.heatmap.Heatmap;
import adams.flow.transformer.multiheatmapoperation.AbstractMultiHeatmapOperation;

public class Add
extends AbstractMultiHeatmapOperation<Heatmap> {
    private static final long serialVersionUID = 6124767252812041585L;

    public String globalInfo() {
        return "Adds the values of the heatmaps.";
    }

    @Override
    public int minNumSheetsRequired() {
        return 2;
    }

    @Override
    public int maxNumSheetsRequired() {
        return 0;
    }

    @Override
    public Class generates() {
        return Heatmap.class;
    }

    @Override
    protected void check(Heatmap[] maps) {
        super.check(maps);
        for (int i = 1; i < maps.length; ++i) {
            if (maps[0].getWidth() != maps[i].getWidth()) {
                throw new IllegalStateException("Heatmap 1 and " + (i + 1) + " differ in width: " + maps[0].getWidth() + " != " + maps[i].getWidth());
            }
            if (maps[0].getHeight() == maps[i].getHeight()) continue;
            throw new IllegalStateException("Heatmap 1 and " + (i + 1) + " differ in height: " + maps[0].getHeight() + " != " + maps[i].getHeight());
        }
    }

    @Override
    protected Heatmap doProcess(Heatmap[] maps, MessageCollection errors) {
        Heatmap result = maps[0].getClone();
        for (int i = 1; i < maps.length; ++i) {
            for (int y = 0; y < result.getHeight(); ++y) {
                for (int x = 0; x < result.getWidth(); ++x) {
                    result.set(y, x, result.get(y, x) + maps[i].get(y, x));
                }
            }
        }
        return result;
    }
}

