/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.heatmap.selection;

import adams.data.filter.heatmapcrop.Submap;
import adams.data.heatmap.Heatmap;
import adams.data.report.Report;
import adams.gui.visualization.heatmap.HeatmapPanel;
import adams.gui.visualization.heatmap.selection.AbstractSelectionProcessor;
import adams.gui.visualization.image.ImagePanel;
import java.awt.Point;

public class Crop
extends AbstractSelectionProcessor {
    private static final long serialVersionUID = -657789971297807743L;
    public static final String PREFIX = "Crop.";
    public static final String KEY_X = "x";
    public static final String KEY_Y = "y";
    public static final String KEY_WIDTH = "width";
    public static final String KEY_HEIGHT = "height";

    public String globalInfo() {
        return "Crops the heatmap to the current selection and stores crop information in the report (prefix: Crop.). Offers undo/redo.";
    }

    @Override
    protected void doProcessSelection(HeatmapPanel panel, Point topLeft, Point bottomRight, int modifiersEx) {
        ImagePanel.PaintPanel ppanel = panel.getImagePanel().getPaintPanel();
        int x = ppanel.mouseToPixelLocation((Point)topLeft).x;
        int y = ppanel.mouseToPixelLocation((Point)topLeft).y;
        int width = ppanel.mouseToPixelLocation((Point)bottomRight).x - ppanel.mouseToPixelLocation((Point)topLeft).x + 1;
        int height = ppanel.mouseToPixelLocation((Point)bottomRight).y - ppanel.mouseToPixelLocation((Point)topLeft).y + 1;
        Submap submap = new Submap();
        submap.setRow(y);
        submap.setColumn(x);
        submap.setHeight(height);
        submap.setWidth(width);
        Heatmap cropped = submap.crop(panel.getHeatmap());
        Report additional = cropped.getReport();
        additional.setNumericValue("Crop.x", (double)x);
        additional.setNumericValue("Crop.y", (double)y);
        additional.setNumericValue("Crop.width", (double)width);
        additional.setNumericValue("Crop.height", (double)height);
        if (panel.getOwner() != null) {
            panel.getOwner().newTab(cropped, "Cropped");
        } else {
            panel.setHeatmap(cropped);
        }
    }
}

