/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.webserver;

import adams.core.base.BaseString;
import adams.core.io.PlaceholderDirectory;
import adams.flow.standalone.webserver.AbstractHandler;
import org.eclipse.jetty.server.Handler;

public class ResourceHandler
extends AbstractHandler {
    private static final long serialVersionUID = 6990526124551806254L;
    protected PlaceholderDirectory m_DocumentRoot;
    protected BaseString[] m_WelcomeFiles;
    protected boolean m_ListDirectories;

    @Override
    public String globalInfo() {
        return "Wrapper around a " + org.eclipse.jetty.server.handler.ResourceHandler.class.getName() + " to allow parametrization through ADAMS.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("document-root", "documentRoot", (Object)new PlaceholderDirectory());
        this.m_OptionManager.add("welcome-file", "welcomeFiles", (Object)new BaseString[]{new BaseString("index.htm"), new BaseString("index.html")});
        this.m_OptionManager.add("list-dirs", "listDirectories", (Object)true);
    }

    public void setDocumentRoot(PlaceholderDirectory value) {
        this.m_DocumentRoot = value;
        this.reset();
    }

    public PlaceholderDirectory getDocumentRoot() {
        return this.m_DocumentRoot;
    }

    public String documentRootTipText() {
        return "The directory containing the static files.";
    }

    public void setWelcomeFiles(BaseString[] value) {
        this.m_WelcomeFiles = value;
        this.reset();
    }

    public BaseString[] getWelcomeFiles() {
        return this.m_WelcomeFiles;
    }

    public String welcomeFilesTipText() {
        return "The files to serve automatically if requested URL lists no file (eg 'index.html').";
    }

    public void setListDirectories(boolean value) {
        this.m_ListDirectories = value;
        this.reset();
    }

    public boolean getListDirectories() {
        return this.m_ListDirectories;
    }

    public String listDirectoriesTipText() {
        return "If enabled, directories are listed.";
    }

    @Override
    public Handler configureHandler() {
        org.eclipse.jetty.server.handler.ResourceHandler result = new org.eclipse.jetty.server.handler.ResourceHandler();
        result.setDirectoriesListed(this.m_ListDirectories);
        String[] files = new String[this.m_WelcomeFiles.length];
        for (int i = 0; i < this.m_WelcomeFiles.length; ++i) {
            files[i] = this.m_WelcomeFiles[i].getValue();
        }
        result.setWelcomeFiles(files);
        result.setResourceBase(this.m_DocumentRoot.getAbsolutePath());
        return result;
    }
}

