/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.io.FileUtils;
import adams.core.io.PlaceholderFile;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class HTMLFileReader
extends AbstractTransformer {
    private static final long serialVersionUID = -184602726110144511L;

    public String globalInfo() {
        return "Reads an HTML file and forwards the parsed " + Document.class.getName() + " object.";
    }

    public Class[] accepts() {
        return new Class[]{String.class, File.class};
    }

    public Class[] generates() {
        return new Class[]{Document.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doExecute() {
        String result = null;
        Object fileObj = this.m_InputToken.getPayload();
        File file = fileObj instanceof File ? (File)fileObj : new PlaceholderFile((String)fileObj);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file.getAbsoluteFile());
            DOMParser parser = new DOMParser();
            parser.parse(new InputSource(fis));
            Document doc = parser.getDocument();
            this.m_OutputToken = new Token((Object)doc);
        }
        catch (Exception e) {
            try {
                result = this.handleException("Failed to read HTML file: " + file, e);
            }
            catch (Throwable throwable) {
                FileUtils.closeQuietly(fis);
                throw throwable;
            }
            FileUtils.closeQuietly((InputStream)fis);
        }
        FileUtils.closeQuietly((InputStream)fis);
        return result;
    }
}

