/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.env.Environment;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseTabbedPane;
import adams.gui.core.BaseTextArea;
import adams.gui.core.ConsolePanel;
import adams.gui.core.Fonts;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextAreaComponent;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.markdownj.MarkdownProcessor;

public class MarkdownTextAreaWithPreview
extends BasePanel
implements TextAreaComponent {
    private static final long serialVersionUID = -1823780286250700366L;
    protected BaseTabbedPane m_TabbedPane;
    protected BaseTextArea m_TextCode;
    protected JEditorPane m_PanePreview;
    protected MarkdownProcessor m_Processor;

    protected void initialize() {
        super.initialize();
        this.m_Processor = new MarkdownProcessor();
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_TabbedPane = new BaseTabbedPane();
        this.add((Component)this.m_TabbedPane, "Center");
        this.m_TextCode = new BaseTextArea();
        this.m_TextCode.setFont(Fonts.getMonospacedFont());
        this.m_TabbedPane.addTab("Write", (Component)new BaseScrollPane((Component)this.m_TextCode));
        this.m_PanePreview = new JEditorPane();
        this.m_PanePreview.setEditable(false);
        this.m_PanePreview.setContentType("text/html");
        this.m_TabbedPane.addTab("Preview", (Component)new BaseScrollPane((Component)this.m_PanePreview));
        this.m_TabbedPane.addChangeListener(e -> this.update());
    }

    public void setText(String value) {
        if (value == null) {
            value = "";
        }
        this.m_TextCode.setText(value);
        this.update();
    }

    public String getText() {
        return this.m_TextCode.getText();
    }

    public Document getDocument() {
        return this.m_TextCode.getDocument();
    }

    public String getSelectedText() {
        return this.m_TextCode.getSelectedText();
    }

    public void setRows(int value) {
        this.m_TextCode.setRows(value);
    }

    public int getRows() {
        return this.m_TextCode.getRows();
    }

    public void setColumns(int value) {
        this.m_TextCode.setColumns(value);
    }

    public int getColumns() {
        return this.m_TextCode.getColumns();
    }

    public void setEditable(boolean value) {
        this.m_TextCode.setEditable(value);
    }

    public boolean isEditable() {
        return this.m_TextCode.isEditable();
    }

    public void setLineWrap(boolean value) {
        this.m_TextCode.setLineWrap(value);
    }

    public boolean getLineWrap() {
        return this.m_TextCode.getLineWrap();
    }

    public void setWrapStyleWord(boolean value) {
        this.m_TextCode.setWrapStyleWord(value);
    }

    public boolean getWrapStyleWord() {
        return this.m_TextCode.getWrapStyleWord();
    }

    public void setTextFont(Font value) {
        this.m_TextCode.setFont(value);
    }

    public Font getTextFont() {
        return this.m_TextCode.getFont();
    }

    public void setCaretPosition(int pos) {
        this.m_TextCode.setCaretPosition(pos);
    }

    public int getCaretPosition() {
        return this.m_TextCode.getCaretPosition();
    }

    public void setCaretPositionLast() {
        this.m_TextCode.setCaretPositionLast();
    }

    protected void update() {
        String html = this.m_Processor.markdown(this.getText());
        try {
            this.m_PanePreview.setText("<html>" + html + "</html>");
            this.m_PanePreview.setCaretPosition(0);
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append("Failed to update preview!", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        BaseFrame frame = new BaseFrame("Markdown test");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)new MarkdownTextAreaWithPreview()), "Center");
        frame.setSize(GUIHelper.getDefaultSmallDialogDimension());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

