/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.core;

import adams.env.Environment;
import adams.gui.core.BaseFrame;
import adams.gui.core.BasePanel;
import adams.gui.core.ConsolePanel;
import adams.gui.core.GUIHelper;
import adams.gui.core.TextPaneComponent;
import com.googlecode.jfilechooserbookmarks.gui.BaseScrollPane;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.markdownj.MarkdownProcessor;

public class MarkdownTextPane
extends BasePanel
implements TextPaneComponent {
    private static final long serialVersionUID = -3021897813785552183L;
    protected MarkdownProcessor m_Processor;
    protected String m_Markdown;
    protected JEditorPane m_PaneView;

    protected void initialize() {
        super.initialize();
        this.m_Processor = new MarkdownProcessor();
        this.m_Markdown = "";
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_PaneView = new JEditorPane();
        this.m_PaneView.setEditable(false);
        this.m_PaneView.setContentType("text/html");
        this.add((Component)new BaseScrollPane((Component)this.m_PaneView), "Center");
    }

    public void setText(String value) {
        if (value == null) {
            value = "";
        }
        this.m_Markdown = value;
        String html = this.m_Processor.markdown(this.m_Markdown);
        try {
            this.m_PaneView.setText("<html>" + html + "</html>");
            this.m_PaneView.setCaretPosition(0);
        }
        catch (Exception e) {
            ConsolePanel.getSingleton().append("Failed to update preview!", (Throwable)e);
        }
    }

    public String getText() {
        return this.m_Markdown;
    }

    public String getSelectedText() {
        return this.m_PaneView.getSelectedText();
    }

    public void setEditable(boolean value) {
        this.m_PaneView.setEditable(value);
    }

    public boolean isEditable() {
        return this.m_PaneView.isEditable();
    }

    public Document getDocument() {
        return this.m_PaneView.getDocument();
    }

    public void setCaretPosition(int value) {
        this.m_PaneView.setCaretPosition(value);
    }

    public int getCaretPosition() {
        return this.m_PaneView.getCaretPosition();
    }

    public void setCaretPositionLast() {
        this.setCaretPosition(this.getDocument().getLength());
    }

    public static void main(String[] args) {
        Environment.setEnvironmentClass(Environment.class);
        MarkdownTextPane pane = new MarkdownTextPane();
        pane.setText("# Markdown test\n\n* item 1\n* item 2\n\n## Other stuff\n*italic* __bold__");
        BaseFrame frame = new BaseFrame("Markdown test");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new BorderLayout());
        frame.getContentPane().add((Component)((Object)pane), "Center");
        frame.setSize(GUIHelper.getDefaultSmallDialogDimension());
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

