/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.goe;

import adams.core.Utils;
import adams.core.base.BaseMarkdown;
import adams.core.base.BaseObject;
import adams.core.option.parsing.BaseMarkdownParsing;
import adams.gui.core.BaseButton;
import adams.gui.core.BaseCheckBox;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MarkdownTextAreaWithPreview;
import adams.gui.goe.AbstractPropertyEditorSupport;
import adams.gui.goe.CustomStringRepresentationHandler;
import adams.gui.goe.InlineEditorSupport;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class BaseMarkdownEditor
extends AbstractPropertyEditorSupport
implements CustomStringRepresentationHandler,
InlineEditorSupport {
    protected MarkdownTextAreaWithPreview m_TextValue;

    public String toCustomStringRepresentation(Object obj) {
        return BaseMarkdownParsing.toString(null, (Object)obj);
    }

    public Object fromCustomStringRepresentation(String str) {
        return BaseMarkdownParsing.valueOf(null, (String)str);
    }

    public String getJavaInitializationString() {
        String result = "new " + this.getValue().getClass().getName() + "(\"" + BaseMarkdownParsing.toString(null, (Object)this.getValue()) + "\")";
        return result;
    }

    public void paintValue(Graphics gfx, Rectangle box) {
        FontMetrics fm = gfx.getFontMetrics();
        int vpad = (box.height - fm.getHeight()) / 2;
        String val = this.getValue() == null ? "[null]" : BaseMarkdownParsing.toString(null, (Object)this.getValue());
        if (val.isEmpty()) {
            val = "[empty]";
        }
        gfx.drawString(val, 2, fm.getHeight() + vpad);
    }

    protected JComponent createCustomEditor() {
        JPanel panelAll = new JPanel(new BorderLayout());
        this.m_TextValue = new MarkdownTextAreaWithPreview();
        this.m_TextValue.setRows(30);
        this.m_TextValue.setColumns(80);
        panelAll.add((Component)new BaseScrollPane((Component)((Object)this.m_TextValue)), "Center");
        panelAll.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel panelButtons = new JPanel(new BorderLayout());
        panelAll.add((Component)panelButtons, "South");
        JPanel panel = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panel, "West");
        BaseButton buttonClear = new BaseButton("Clear");
        buttonClear.setMnemonic('l');
        buttonClear.setIcon((Icon)GUIHelper.getIcon((String)"new.gif"));
        buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMarkdownEditor.this.m_TextValue.setText("");
            }
        });
        panel.add((Component)buttonClear);
        final BaseCheckBox checkLineWrap = new BaseCheckBox("Line wrap");
        checkLineWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMarkdownEditor.this.m_TextValue.setLineWrap(checkLineWrap.isSelected());
            }
        });
        panel.add((Component)checkLineWrap);
        panel = new JPanel(new FlowLayout(2));
        panelButtons.add((Component)panel, "East");
        BaseButton buttonOK = new BaseButton("OK");
        buttonOK.setMnemonic('O');
        buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String s = BaseMarkdownEditor.this.m_TextValue.getText();
                if (((BaseMarkdown)BaseMarkdownEditor.this.getValue()).isValid(s) && !s.equals(((BaseObject)BaseMarkdownEditor.this.getValue()).getValue())) {
                    BaseMarkdownEditor.this.setValue(new BaseMarkdown(s));
                }
                BaseMarkdownEditor.this.closeDialog(1);
            }
        });
        panel.add((Component)buttonOK);
        BaseButton buttonClose = new BaseButton("Cancel");
        buttonClose.setMnemonic('C');
        buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BaseMarkdownEditor.this.closeDialog(0);
            }
        });
        panel.add((Component)buttonClose);
        return panelAll;
    }

    protected void initForDisplay() {
        super.initForDisplay();
        if (!this.m_TextValue.getText().equals("" + this.getValue())) {
            this.m_TextValue.setText("" + this.getValue());
        }
    }

    public boolean isInlineEditingAvailable() {
        return true;
    }

    public void setInlineValue(String value) {
        this.setValue(new BaseMarkdown(Utils.unbackQuoteChars((String)value)));
    }

    public String getInlineValue() {
        return Utils.backQuoteChars((String)((BaseMarkdown)this.getValue()).getValue());
    }

    public boolean isInlineValueValid(String value) {
        return true;
    }
}

