/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.webserver;

import adams.core.io.FileUtils;
import adams.core.logging.Logger;
import adams.core.logging.LoggingHelper;
import adams.core.logging.LoggingLevel;
import adams.core.logging.LoggingLevelHandler;
import adams.core.logging.LoggingSupporter;
import adams.core.net.MimeTypeHelper;
import adams.gui.core.ImageManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.tika.mime.MediaType;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.resource.Resource;

public abstract class AbstractJettyHandler
extends AbstractHandler
implements LoggingSupporter,
LoggingLevelHandler {
    protected long m_ModifiedTimestamp = System.currentTimeMillis() / 1000L * 1000L;
    protected byte[] m_Favicon;
    protected boolean m_ServeIcon;
    protected HashMap<String, Long> m_ImageModified;
    protected HashMap<String, String> m_ImageMimeTypes;
    protected Logger m_Logger;
    protected LoggingLevel m_LoggingLevel;

    public AbstractJettyHandler() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Logger = null;
        this.m_LoggingLevel = LoggingHelper.getLoggingLevel(((Object)((Object)this)).getClass());
        this.m_ServeIcon = true;
        this.m_Favicon = this.loadImage("adams_icon.ico");
        this.m_ModifiedTimestamp = System.currentTimeMillis() / 1000L * 1000L;
        this.m_ImageModified = new HashMap();
        this.m_ImageMimeTypes = new HashMap();
        this.m_ImageMimeTypes.put("gif", "image/gif");
        this.m_ImageMimeTypes.put("png", "image/png");
        this.m_ImageMimeTypes.put("ico", "image/x-icon");
        this.m_ImageMimeTypes.put("bmp", "image/bmp");
        this.m_ImageMimeTypes.put("tif", "image/tiff");
        this.m_ImageMimeTypes.put("tiff", "image/tiff");
        this.m_ImageMimeTypes.put("jpg", "image/jpeg");
        this.m_ImageMimeTypes.put("jpeg", "image/jpeg");
    }

    public synchronized Logger getLogger() {
        if (this.m_Logger == null) {
            this.m_Logger = LoggingHelper.getLogger(((Object)((Object)this)).getClass());
        }
        return this.m_Logger;
    }

    public boolean isLoggingEnabled() {
        return LoggingHelper.isAtLeast((Logger)this.getLogger(), (Level)Level.INFO);
    }

    public void setLoggingLevel(LoggingLevel value) {
        this.m_LoggingLevel = value;
        if (this.m_Logger != null) {
            this.m_Logger.setLevel(value.getLevel());
        }
    }

    public LoggingLevel getLoggingLevel() {
        return this.m_LoggingLevel;
    }

    protected byte[] loadImage(String name) {
        byte[] result = null;
        try {
            String fullname = ImageManager.getImageFilename((String)name);
            URL url = ((Object)((Object)this)).getClass().getClassLoader().getResource(fullname);
            if (url != null) {
                Resource res = Resource.newResource((URL)url);
                result = IO.readBytes((InputStream)res.getInputStream());
            }
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load image: " + name, (Throwable)e);
        }
        return result;
    }

    protected String getImageMimeType(String image) {
        String ext = FileUtils.getExtension((String)image);
        if (this.m_ImageMimeTypes.containsKey(ext)) {
            return this.m_ImageMimeTypes.get(ext);
        }
        String fullname = ImageManager.getImageFilename((String)image);
        if (fullname != null) {
            MediaType mime = MimeTypeHelper.getMimeType((String)fullname);
            this.m_ImageMimeTypes.put(ext, mime.toString());
        } else {
            this.m_ImageMimeTypes.put(ext, "application/octet-stream");
        }
        return this.m_ImageMimeTypes.get(ext);
    }

    protected void serveFavicon(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString()) == this.m_ModifiedTimestamp) {
            response.setStatus(304);
        } else {
            response.setStatus(200);
            response.setContentType("image/x-icon");
            response.setContentLength(this.m_Favicon.length);
            response.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), this.m_ModifiedTimestamp);
            response.setHeader(HttpHeader.CACHE_CONTROL.toString(), "max-age=360000,public");
            response.getOutputStream().write(this.m_Favicon);
        }
    }

    protected void serveImage(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        String image = request.getRequestURI().substring(request.getRequestURI().lastIndexOf(47) + 1);
        if (this.m_ImageModified.containsKey(image) && request.getDateHeader(HttpHeader.IF_MODIFIED_SINCE.toString()) == this.m_ModifiedTimestamp) {
            response.setStatus(304);
        } else {
            byte[] data = this.loadImage(image);
            response.setStatus(200);
            response.setContentType(this.getImageMimeType(image));
            response.setContentLength(data.length);
            response.setDateHeader(HttpHeader.LAST_MODIFIED.toString(), this.m_ModifiedTimestamp);
            response.setHeader(HttpHeader.CACHE_CONTROL.toString(), "max-age=360000,public");
            response.getOutputStream().write(data);
            this.m_ImageModified.put(image, this.m_ModifiedTimestamp);
        }
    }

    protected abstract void doHandle(String var1, Request var2, HttpServletRequest var3, HttpServletResponse var4) throws IOException, ServletException;

    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (response.isCommitted() || baseRequest.isHandled()) {
            return;
        }
        baseRequest.setHandled(true);
        String method = request.getMethod();
        if (this.m_ServeIcon && this.m_Favicon != null && method.equals(HttpMethod.GET) && request.getRequestURI().equals("/favicon.ico")) {
            this.serveFavicon(target, baseRequest, request, response);
            return;
        }
        String ext = FileUtils.getExtension((String)request.getRequestURI());
        if (this.m_ImageMimeTypes.containsKey(ext)) {
            this.serveImage(target, baseRequest, request, response);
            return;
        }
        this.doHandle(target, baseRequest, request, response);
    }
}

