/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.standalone.webserver;

import adams.core.License;
import adams.core.annotation.MixedCopyright;
import adams.flow.control.Flow;
import adams.flow.control.RunningFlowsRegistry;
import adams.flow.standalone.webserver.AbstractHandler;
import adams.flow.standalone.webserver.AbstractJettyHandler;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;

@MixedCopyright(copyright="1995-2012 Mort Bay Consulting Pty. Ltd.", license=License.APACHE2, note="Code re-used from org.eclipse.jetty.server.handler.DefaultHandler")
public class RunningFlowsHandler
extends AbstractHandler {
    private static final long serialVersionUID = -532387689323836800L;

    @Override
    public String globalInfo() {
        return "Returns a handler that generates a website showing the currently running flows.";
    }

    @Override
    public Handler configureHandler() {
        CustomHandler result = new CustomHandler();
        result.setLoggingLevel(this.getLoggingLevel());
        return result;
    }

    public static class CustomHandler
    extends AbstractJettyHandler {
        @Override
        protected void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
            String method = request.getMethod();
            if (!method.equals(HttpMethod.GET.toString()) || !request.getRequestURI().equals("/")) {
                response.sendError(404);
                return;
            }
            Flow[] flows = RunningFlowsRegistry.getSingleton().flows();
            String hashcodeStr = request.getParameter("flow");
            String action = request.getParameter("action");
            if (action != null && hashcodeStr != null) {
                Flow flow = null;
                int hashcode = Integer.parseInt(hashcodeStr);
                for (int i = 0; i < flows.length; ++i) {
                    if (flows[i].hashCode() != hashcode) continue;
                    flow = flows[i];
                    break;
                }
                if (flow != null) {
                    if (action.equals("pause")) {
                        flow.pauseExecution();
                    } else if (action.equals("resume")) {
                        flow.resumeExecution();
                    } else if (action.equals("stop")) {
                        flow.stopExecution();
                    }
                }
            }
            response.setStatus(200);
            response.setContentType(MimeTypes.Type.TEXT_HTML.toString());
            ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(1500);
            writer.write("<html>\n");
            writer.write("<head>\n<title>Running flows</title></head>\n");
            writer.write("<link rel=\"SHORTCUT ICON\" href=\"/favicon.ico\"/>\n");
            writer.write("<body>\n<h2>Running flows</h2>\n");
            writer.write("<ol>\n");
            for (Flow flow : flows) {
                writer.write("  <li>");
                writer.write(flow.getVariables().get("flow_filename_short"));
                writer.write("&nbsp;");
                if (flow.isPaused()) {
                    writer.write("<a href=\"/?action=resume&flow=" + flow.hashCode() + "\"><img border=\"0\" src=\"/resume.gif\"/></a>");
                } else {
                    writer.write("<a href=\"/?action=pause&flow=" + flow.hashCode() + "\"><img border=\"0\" src=\"/pause.gif\"/></a>");
                }
                writer.write("&nbsp;");
                writer.write("<a href=\"/?action=stop&flow=" + flow.hashCode() + "\"><img border=\"0\" src=\"/stop_blue.gif\"/></a>");
                writer.write("</li>\n");
            }
            writer.write("</ol>\n");
            writer.write("</body>\n");
            writer.write("</html>\n");
            writer.flush();
            response.setContentLength(writer.size());
            ServletOutputStream out = response.getOutputStream();
            writer.writeTo((OutputStream)out);
            out.close();
            writer.close();
        }
    }
}

