/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.flow.tree.annotations;

import adams.gui.flow.tree.Node;
import adams.gui.flow.tree.annotations.AbstractAnnotationProcessor;
import org.markdownj.MarkdownProcessor;

public class Markdown
extends AbstractAnnotationProcessor {
    private static final long serialVersionUID = -312797137959308577L;
    protected transient MarkdownProcessor m_MarkdownProcessor;

    public String globalInfo() {
        return "Turns the markdown annotations into HTML.";
    }

    protected synchronized MarkdownProcessor getProcessor() {
        if (this.m_MarkdownProcessor == null) {
            this.m_MarkdownProcessor = new MarkdownProcessor();
        }
        return this.m_MarkdownProcessor;
    }

    public String toHTML(Node node) {
        String colorDef = node.hasOwner() ? node.getOwner().getAnnotationsColor() : "blue";
        String sizeDef = node.hasOwner() ? node.getOwner().getAnnotationsSize() : "-2";
        StringBuilder result = new StringBuilder();
        result.append("<font " + node.generateSizeAttribute(sizeDef) + " color='" + colorDef + "'>");
        result.append(this.getProcessor().markdown(node.getActor().getAnnotations().getValue()));
        result.append("</font>");
        return result.toString();
    }
}

